#include <QApplication>
#include <QOpenGLWidget>
#include <QOpenGLFunctions_3_3_Core>
#include <QOpenGLShaderProgram>
#include <iostream>
using namespace std;

class GLWidget : public QOpenGLWidget, public QOpenGLFunctions_3_3_Core
{
    virtual void initializeGL();
    virtual void paintGL();
	void setScene();
	void compileShaders();

	GLuint VAO;
	int numVerts;
    QOpenGLShaderProgram shaders; 
};


void GLWidget::setScene()
{
	// vertex data in RAM
	vector<QVector3D> vertices;
  	vertices.push_back( QVector3D( 0, 1, 0) ); //     V0			
	vertices.push_back( QVector3D(-1,-1, 0) ); //   /    \      /
	vertices.push_back( QVector3D( 1,-1, 0) ); //  V1 -- V2

	// create VAO from vertex data
	glGenVertexArrays(1, &VAO);
  	glBindVertexArray(VAO);
	GLuint VBO;
  	glGenBuffers(1, &VBO);
  	glBindBuffer(GL_ARRAY_BUFFER, VBO);
	glBufferData(GL_ARRAY_BUFFER, sizeof(QVector3D)*vertices.size(), &vertices[0], GL_STATIC_DRAW);
  	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, 0);
  	glEnableVertexAttribArray(0);

	numVerts = vertices.size();
}

void GLWidget::compileShaders()
{
   	// VS
    QString vs_src =
      "#version 330 core\n"
      "in vec3 vertex;"
      "void main() {"
      "  gl_Position = vec4(vertex,1.0);"
      "}";
    QOpenGLShader vs(QOpenGLShader::Vertex);
    vs.compileSourceCode(vs_src);

	// FS
    QString fs_src =
      "#version 330 core\n"
      "out vec4 fragColor;"
      "void main() { fragColor=vec4(0,0,1,0); }";
    QOpenGLShader fs(QOpenGLShader::Fragment);
    fs.compileSourceCode(fs_src);

    // VS + FS 
    shaders.addShader(&vs);
    shaders.addShader(&fs);
    shaders.link();
}

void GLWidget::initializeGL()
{	
	setFocusPolicy(Qt::ClickFocus);
	initializeOpenGLFunctions();
	glClearColor(1, 1, 1, 1);
	setScene();
	compileShaders();
}

void GLWidget::paintGL()
{
	glClear(GL_COLOR_BUFFER_BIT);
	glViewport(0, 0, width(), height());
	shaders.bind();	
	glBindVertexArray(VAO); 
	glDrawArrays(GL_TRIANGLES, 0, numVerts); // draw scene
}

void setOpenGLVersion(int major, int minor)
{
    QSurfaceFormat glFormat;
    glFormat.setVersion(major, minor);
    glFormat.setProfile(QSurfaceFormat::CoreProfile); 
    QSurfaceFormat::setDefaultFormat(glFormat);
}

int main(int argc, char ** argv)
{
    QApplication app(argc, argv); // create Qt app
	setOpenGLVersion(3,3);		  // OpenGL 3.3 core	
    GLWidget glWidget;			  // create OpenGL window
    glWidget.show();			  // make it visible
	return app.exec();			  // run the app	
}


