
%% ------------ [2.5 points] ------------ %%

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   A mechanical workshop employs three mechanics with different specializations and a maximum
   working capacity of 8 hours each per day. The workshop needs to assign 9 pending tasks to the
   mechanics, respecting their skill sets, the time constraint, and an urgent task policy. Every
   task must be assigned to exactly one mechanic.

   Mechanics:
    MechID  Name   Specialization                                Time constraint
       1    Ted    Mechanical Specialist                         Max 8 hours
       2    Karen  Electrical and General Inspection Specialist  Max 8 hours
       3    Brian  Versatile (Can perform most short tasks)      Max 8 hours

   Tasks, durations, and skill constraints
    TaskID   Task                 Duration   Skill constraints
       1     Brakes                  4h      Ted (1) or Karen (2) only
       2     Tires                   2h      Any mechanic
       3     General inspection      3h      Karen (2) or Brian (3) only
       4     Battery                 1h      Electrical task: Karen (2) or Brian (3) only
       5     Lights                  1h      Electrical task: Karen (2) or Brian (3) only
       6     Filters                 2h      Any mechanic
       7     Clutch replacement      3h      Ted (1) or Brian (3) only
       8     Urgent task A           2h      Any mechanic
       9     Urgent task B           1h      Any mechanic

   Constraints summary
     * Skill match: the assigned mechanic must be qualified to perform the specific task
       (as per the "Skill constraints" column).
     * Time constraint: no mechanic can be assigned tasks totaling more than 8 hours of work.
     * Urgent task exclusion: a single mechanic cannot be assigned both urgent tasks (tasks 8 and 9).
       If a mechanic is assigned task 8, they cannot be assigned task 9, and vice versa.

   Objective: find a feasible assignment of all 9 tasks to the 3 mechanics such that
              all the above constraints are satisfied.

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

:- use_module(library(clpfd)).

% taskLengths(Hours): list of each task's duration
taskLengths([4, 2, 3, 1, 1, 2, 3, 2, 1]). 

%% To invoke the program USE THIS predicate main/0.
main :-
    main(_), !, halt.

%% Our external solution checker will use the argument in main/1 to check your solution.
main(Assignments) :-

%1: Variables and domains:
%1a Variables that define the assignment
    % A1..A9: Mechanic ID assigned
    Assignments = [A1, A2, A3, A4, A5, A6, A7, A8, A9],
    %% ... Domain: TO BE COMPLETED:
    
%1b Binary variables to calculate total hours
    % H_ij = 1 if task i is assigned to mechanic j, 0 otherwise.
    H = [H11, H12, H13, 
         H21, H22, H23, 
         H31, H32, H33, 
         H41, H42, H43, 
         H51, H52, H53, 
         H61, H62, H63, 
         H71, H72, H73, 
         H81, H82, H83, 
         H91, H92, H93],
    %% ... Domain: TO BE COMPLETED:

%2: Constraints:    
%2a Competence/skills restrictions
    %  1.  Brakes (A1): Ted (1) or Karen (2)
    %  2.  Tires (A2): Any (1, 2, 3)
    %  3.  General inspection (A3): Karen (2) or Brian (3)
    % 4+5. Battery (A4), and Lights (A5): Karen (2) or Brian (3)
    %  6.  Filters (A6): Any
    %  7.  Clutch replacement (A7): Ted (1) or Brian (3)
    %  8.  Urgent task A (A8): Any
    %  9.  Urgent task B (A9): Any
    %% ... TO BE COMPLETED:
   
%2b The following constraints link Assignment Variables with Binary Variables (H_ij).
    % The A_i assignment must match exactly one H_ij = 1.
    % HINT: use (A_i #= j) #<==> (...)
    %       where    P #<==> Q    expresses that P and Q are equivalent (P, Q in 0..1)
    %       https://www.swi-prolog.org/pldoc/doc_for?object=%23%3C%3D%3D%3E%20/%202
    %% ... TO BE COMPLETED:

%2c Limit on the overall number of working hours per mechanic, utilizing scalar_product/4.
    % https://www.swi-prolog.org/pldoc/doc_for?object=scalar_product/4

    taskLengths(Durations),

    % Hours of Ted (1): all Ted tasks * their duration. Max: 8 hours
    %% ... TO BE COMPLETED:
    HoursTed = [...]
    scalar_product(..., ..., ..., ...),

    % Hours of Karen (2): all Karen tasks * their duration. Max: 8 hours
    %% ... TO BE COMPLETED:
    HoursKaren = [...]
    scalar_product(..., ..., ..., ...),

    % Hours of Brian (3): all Brian tasks * their duration. Max: 8 hours
    %% ... TO BE COMPLETED:
    HoursBrian = [...]
    scalar_product(..., ..., ..., ...),
    
%2d Restriction of urgent tasks (A8 and A9)
    % Maximum of one urgent task per mechanic
    %% ... TO BE COMPLETED:
    
%3: Labeling:
    %% ... TO BE COMPLETED:
    label(...),

%4: Show the result:
    write(Assignments), nl,
    displaySolution(Assignments), nl.



displaySolution(Assignments) :-
    taskNames(TskNames),
    taskLengths(Durations),
    mechanicNames(MecNames),
    nth1(I, TskNames, Task),
    nth1(I, Durations, Hours),
    nl,
    write('task '), write(I), write(' ['), write(Task), write('-'), write(Hours), write('h]: '),
    write('mechanic '),
    nth1(I, Assignments, J),
    nth1(J, MecNames, Name),
    write(J), write(' ['), write(Name), write(']'), fail.
displaySolution(_).

% These are auxiliary predicates that you do not need to pay attention to.
% Only in displaySolution/1 are the task names and mechanic names used.
taskNames(['brakes', 'tires', 'generalInspection', 'battery', 'lights', 'filters', 'clutchReplacement', 'urgentTaskA', 'urgentTaskB']).

% Mechanics: 1 = Ted, 2 = Karen, 3 = Brian
mechanicNames(['Ted', 'Karen', 'Brian']).

