/*
A farmer with a wolf, a goat and a cabbage must cross a river by
boat. The boat can carry only the farmer and at most a single item. If
left unattended together, the wolf would eat the goat, or the goat
would eat the cabbage. How can they all cross the river without anything
being eaten, in the minimum number of steps?

Complete the following Prolog code to solve the puzzle.

Assume that initially the farmer, the wolf, the goat and the cabbage
are on the left bank of the river. States MUST BE represented as lists
with 4 items of the form

[ [f, A], [w, B], [g, C], [c, D] ]

where:

- 'f' stands for the farmer
- 'w' stands for the wolf
- 'g' stands for the goat
- 'c' stands for the cabbage

and A, B, C, D can be either 'l' or 'r',
standing for left and right respectively.

Hint: the optimal solution has cost 7.
*/

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

initialState( [ [f, l], [w, l], [g, l], [c, l] ] ).
finalState( [ [f, r], [w, r], [g, r], [c, r] ] ).

cross(l, r).
cross(r, l).

unsafe(X, [[w, X], [g, X], _]).
unsafe(X, [_, [g, X], [c, X]]).

oneStep(1, [[f, X] | O], [[f, Y] | N] ) :-
    cross(X, Y),
    append(A, [ [I, X] | B], O),
    append(A, [ [I, Y] | B], N),
    not(unsafe(X, N)).
oneStep(1, [[f, X] | S], [[f, Y] | S] ) :-
    cross(X, Y),
    not(unsafe(X, S)).

/* ---- Alternative solution: ----
safe(X, [[w, X], [g, X], _]) :- !, fail.
safe(X, [_, [g, X], [c, X]]) :- !, fail.
safe(_, _).

oneStep(1, [[f, X] | O], [[f, Y] | N] ) :-
    cross(X, Y),
    append(A, [ [I, X] | B], O),
    append(A, [ [I, Y] | B], N),
    safe(X, N).
oneStep(1, [[f, X] | S], [[f, Y] | S] ) :-
    cross(X, Y),
    safe(X, S).
*/


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Modifications to the scheme below are not allowed                            %%

main :-
    solution(Path, MaxCost),
    write(Path), write(' with cost '), write(MaxCost), nl, halt.

solution(Path, MaxCost) :-
    initialState(InitialState),
    finalState(FinalState),
    between(0, 1000, MaxCost),
    path(MaxCost, InitialState, FinalState, [InitialState], RevPath),
    reverse(RevPath, Path).

path(0, E, E, C, C).
path(MaxCost, CurrentState, FinalState, PathSoFar, PathTotal) :-
        MaxCost > 0,
        oneStep(CostStep, CurrentState, NextState),
        \+ member(NextState, PathSoFar),
        MaxCost1 is MaxCost - CostStep,
        path(MaxCost1, NextState, FinalState, [NextState|PathSoFar], PathTotal).
%%                                                                              %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



