#include "mainwindowimpl.h"
//
MainWindowImpl::MainWindowImpl( QWidget * parent, Qt::WFlags f) 
	: QMainWindow(parent, f)
{
	setupUi(this);
	connects();
	mostraFitxer("");
}


void MainWindowImpl::connects()
{
	connect(actionNou, SIGNAL(triggered()), this, SLOT(newFile()));
	connect(actionObrir, SIGNAL(triggered()), this, SLOT(open()));
	connect(actionGuardar, SIGNAL(triggered()), this, SLOT(save()));
	connect(actionGuardar_com, SIGNAL(triggered()), this, SLOT(saveAs()));
	connect(actionSortir, SIGNAL(triggered()), this, SLOT(close()));
	connect(actionRetalla, SIGNAL(triggered()), textEdit, SLOT(cut()));
	connect(actionCopia, SIGNAL(triggered()), textEdit, SLOT(copy()));
	connect(actionEnganxa, SIGNAL(triggered()), textEdit, SLOT(paste()));
	connect(actionAbout, SIGNAL(triggered()), this, SLOT(about()));
	connect(actionAboutQT, SIGNAL(triggered()), this, SLOT(aboutQT()));
	connect(textEdit, SIGNAL(copyAvailable(bool)),actionRetalla, SLOT(setEnabled(bool)));
	connect(textEdit, SIGNAL(copyAvailable(bool)),actionCopia, SLOT(setEnabled(bool)));
	
	connect(textEdit->document(), SIGNAL(contentsChanged()),this, SLOT(documentModificat()));
}

void MainWindowImpl::newFile()
{
    if (potSalvar()) {
        textEdit->clear();
        mostraFitxer("");
    }
}
 
void MainWindowImpl::open()
{
    if (potSalvar()) {
        QString fileName = QFileDialog::getOpenFileName(this);
        if (!fileName.isEmpty())
            carregaFitxer(fileName);
    }
}

bool MainWindowImpl::save()
{
     if (fitxerActual.isEmpty()) {
         return saveAs();
     } else {
         return desaFitxer(fitxerActual);
     }
}

bool MainWindowImpl::saveAs()
{
     QString fileName = QFileDialog::getSaveFileName(this);
     if (fileName.isEmpty())
         return false;

     return desaFitxer(fileName);
}

void MainWindowImpl::carregaFitxer(const QString &fitxer)
{
     QFile file(fitxer);
     if (!file.open(QFile::ReadOnly | QFile::Text)) {
         QMessageBox::warning(this, tr("Editor QT"),
         tr("No puc llegir el fitxer %1:\n%2.")
         .arg(fitxer)
         .arg(file.errorString()));
         return;
     }

     QTextStream in(&file);
     QApplication::setOverrideCursor(Qt::WaitCursor);
     textEdit->setPlainText(in.readAll());
     QApplication::restoreOverrideCursor();

     mostraFitxer(fitxer);
     statusBar()->showMessage(tr("Fitxer carregat"), 3000);
}

bool MainWindowImpl::desaFitxer(const QString &fitxer)
{
     QFile file(fitxer);
     if (!file.open(QFile::WriteOnly | QFile::Text)) {
         QMessageBox::warning(this, tr("Editor QT"),
         tr("No es pot escriure el fitxer %1:\n%2.")
         .arg(fitxer)
         .arg(file.errorString()));
         return false;
     }

     QTextStream out(&file);
     QApplication::setOverrideCursor(Qt::WaitCursor);
     out << textEdit->toPlainText();
     QApplication::restoreOverrideCursor();

     mostraFitxer(fitxer);
     statusBar()->showMessage(tr("Fitxer desat"), 3000);
     return true;
}

void MainWindowImpl::closeEvent(QCloseEvent *event)
{
     if (potSalvar()) {
         escriureParametres();
         event->accept();
     } else {
         event->ignore();
     }
}

void MainWindowImpl::llegirParametres()
{
     QSettings settings("QTEditor", "Editor QT");
     QPoint pos = settings.value("pos", QPoint(200, 200)).toPoint();
     QSize size = settings.value("size", QSize(400, 400)).toSize();
     resize(size);
     move(pos);
}

void MainWindowImpl::escriureParametres()
{
     QSettings settings("QTEditor", "Editor QT");
     settings.setValue("pos", pos());
     settings.setValue("size", size());
}


void MainWindowImpl::documentModificat()
{
     setWindowModified(textEdit->document()->isModified());
}

bool MainWindowImpl::potSalvar()
 {
     if (textEdit->document()->isModified()) {
         QMessageBox::StandardButton ret;
         ret = QMessageBox::warning(this, tr("Editor QT"),
                      tr("El document ha estat modificat.\n"
                         "Vols guardar els canvis?"),
                      QMessageBox::Save | QMessageBox::Discard | QMessageBox::Cancel);
         if (ret == QMessageBox::Save)
             return save();
         else if (ret == QMessageBox::Cancel)
             return false;
     }
     return true;
 }


void MainWindowImpl::mostraFitxer(const QString &nomFitxer)
 {
     fitxerActual = nomFitxer;
     textEdit->document()->setModified(false);
     setWindowModified(false);

     QString shownName;
     if (fitxerActual.isEmpty())
         shownName = "sense-nom.txt";
     else
         shownName = obtenirNomArxiu(fitxerActual);

     setWindowTitle(tr("%1[*] - %2").arg(shownName).arg(tr("Editor QT")));
 }
 
QString MainWindowImpl::obtenirNomArxiu(const QString &fitxer)
 {
     return QFileInfo(fitxer).fileName();
 }

void MainWindowImpl::about()
{
    QMessageBox::about(this, tr("Sobre l'Editor"),
    tr("Aquesta es una aplicacio d'exemple. És un petit editor de " 
    "text on hi ha menus, barra d'eines i barra d'estat."));
}

void MainWindowImpl::aboutQT()
{
    QMessageBox::about(this, tr("Sobre QT"),
    tr("Aquesta aplicacio esta basada en la llibreria QT.<br>"
    "Per obtenir mes informacio us podeu dirigir a la seva "
    "pagina web clicant <a href=\"http://www.trolltech.com\">aqui</a>."));
}
