%% ----------- [3 points] ---------- %%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Given a list of integers L, we want to split L into several smaller lists
% based on this rule: each element in the list belongs to a sublist determined
% by its remainder when divided by a number N. For example, if the number is 3,
% 3 sublists must be created, one for numbers that give a remainder of 0,
% another for numbers that give a remainder of 1, and so on.
%
% Define the predicate classify(L,N,Ls) that, given a list of integers L, and
% a positive integer N, is true when the list Ls consists of N sublists,
% where:
%   - the 0-th sublist of Ls contains all the elements X of L such that X mod N = 0.
%   - the 1-st sublist of Ls contains all the elements X of L such that X mod N = 1.
%   - the 2-nd sublist of Ls contains all the elements X of L such that X mod N = 2.
%   - etc.
% The relative order of elements within each sublist of Ls is maintained as
% they appear in L.
%
% For instance,
%
% ?- classify([13,3,5,1,2,9], 3, Ls).
% Ls = [[3, 9], [13, 1], [5, 2]]
%
% ?- classify([13,3,5,1,2,9], 4, Ls).
% Ls = [[], [13, 5, 1, 9], [2], [3]].
%
% Although there are alternative solutions to the problem, it is MANDATORY
% to follow the indicated guidelines, and complete the predicates:
%   - emptySublists(N,Ls)
%   - appendToSublist(X,N,Ls1,Ls2)
%   - distribute(L,N,Ls1,Ls2)
%   - classify(L,N,Ls)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% emptySublists(+N, ?Ls)  holds if
%     Ls is a list of N empty sublists
% For instance,
% ?- emptySublists(3,Ls).
% Ls = [[], [], []].
emptySublists(N, Ls) :-
    ...


% appendToSublist(+X, +N, +Ls1, ?Ls2)  holds if
%     Ls2 is the result of appending X to the corresponding sublist of Ls1
%     according to X mod N.
% For instance,
% ?- appendToSublist(13, 3, [[9],[7,4],[]], Ls2).
% Ls2 = [[9], [7, 4, 13], []].
appendToSublist(X, N, Ls1, Ls2) :-
    ...
    nth0(I, ...),    %% HINT: use nth0/4
    ...
    nth0(...).

% distribute(+L, +N, +Ls1, ?Ls2)  holds if
%     Ls2 is the result of inserting the items of L into the corresponding
%     sublist of Ls1 according to their modulo N.
% For instance,
% ?- distribute([13,2,5], 3, [[9],[7,4],[]], Ls2).
% Ls2 = [[9], [7, 4, 13], [2, 5]].
distribute([],  ..., ..., ...).
distribute([X|L], N, Ls1, Ls) :-
    ...


% classify(+L, +N, ?Ls)  holds if
%     Ls is the partition of L according to the modulo N  
classify(L, N, Ls) :-
    emptySublists(...),
    ...
