%% ----------- [2.5 points] ---------- %%

/*

A **parenthesization** is a list of left and right parentheses,
that is symbols '(' and ')' respectively,
such that the left and right parentheses match correctly.

More formally:
* The empty list is a parenthesization.
* If E1 and E2 are parenthesizations, then ( E1 ) E2 is a parenthesization.
* Nothing else is a parenthesization.

Note that the number of left and right parentheses in a
parenthesization must be the same.

An example:

()()()
()(())
(())()
(()())
((()))

are all parenthesizations that can be formed with 3 pairs of parentheses
(commas and enclosing brackets of lists are ommitted for the sake of clarity).

Write a Prolog predicate parenthesization(+N, ?L):
given N and a list L of left and right parentheses, it succeeds if L
is a parenthesization with N pairs of parentheses. If L is not given,
under backtracking the predicate should instantiate L to all
parenthesizations with N pairs of parentheses, one after the other
(in any order).

For instance:

?- parenthesization(1, ['(', ')']).
true.

?- parenthesization(2, ['(', ')']).
false.

?- parenthesization(1, [')', ')']).
false.

?- parenthesization(3, L), write(L), nl, fail.
[(,),(,),(,)]
[(,),(,(,),)]
[(,(,),),(,)]
[(,(,),(,),)]
[(,(,(,),),)]
false.

Note that the write predicate in Prolog does not write the enclosing
quotes '' of parentheses. However, these quotes are necessary when
manipulating these symbols, as shown in the example queries above.

*/

parenthesization(0, []) :- !.
parenthesization(N, E) :-
    N1 is N-1,
    between(0, N1, I),
    J is N1-I,
    parenthesization(I, E1),
    parenthesization(J, E2),
    append([['('], E1, [')'], E2], E).
