
%% ------------ [5 points] ------------ %%

symbolicOutput(0).  % set to 1 for DEBUGGING: to see symbolic output only; 0 otherwise.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% The Department of Computer Science needs to organise the
%% invigilation of the final exams of all its subjects.
%%
%% For each subject we have the date and time slot when the exam is to
%% take place, and the exact number of invigilators that are needed.
%% For each member of the department we also have the list of subjects they teach.

%% In what follows, an *external invigilator* of an exam is a member
%% of the department who is called to invigilate the exam but who is
%% not teaching the subject.

%% The following constraints must be respected:
%% (1) Between two exams on the same day, an invigilator needs to rest at least 1 hour.
%% (2) External invigilators are called only when there are not enough teachers of the subject.
%% (3) Nobody can be called as an external invigilator more than once.

%% You can assume that each subject has exactly one exam.

% Find a way to assign the invigilation of the exams so that the above constraints are satisfied
% and the maximum number of invigilated exams by the same person is minimized.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%% begin input example examsExampleA %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% %% examNeeds(Subject, Date, TimeSlot, NumInvigilatorsNeeded).
%% examNeeds('LP', 07/01/2026, [08:00, 11:00],  7).
%% examNeeds('TC', 07/01/2026, [08:00, 11:00],  6).
%% examNeeds( 'A', 12/01/2026, [15:00, 18:00],  8).
%% examNeeds('LI', 15/01/2026, [11:30, 14:30],  4).

%% %% teacherSubjects(Teacher, ListOfSubjects).
%% teacherSubjects('JR', ['LI']).
%% teacherSubjects('TL', ['LI', 'TC']).
%% teacherSubjects('ER', ['LI']).
%% teacherSubjects('MI', ['A']).
%% teacherSubjects('AD', ['A']).
%% teacherSubjects('CM', ['A']).
%% teacherSubjects('MB', ['A']).
%% teacherSubjects('SM', ['A']).
%% teacherSubjects('GE', ['LP']).
%% teacherSubjects('JD', ['LP']).
%% teacherSubjects('JP', ['LP']).
%% teacherSubjects('IB', ['TC']).
%% teacherSubjects('QR', ['TC']).

%%%%%%% end input example examsExampleA %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%% Some helpful definitions to make the code cleaner: ====================================

% If time slots [B1, E1] and [B2, E2] overlap, their distance is 0.
% Otherwise it is the minutes between the end of the earlier slot and the start of the later one. E.g.:
% distanceOfSlots([08:00, 11:00], [11:30, 14:30], 30).
% distanceOfSlots([11:30, 14:30], [08:00, 11:00], 30).
% distanceOfSlots([11:30, 14:30], [14:00, 17:00],  0).
% distanceOfSlots([14:00, 17:00], [17:00, 20:00],  0).
distanceOfSlots([B1, E1], [B2, E2], D) :-
    minutesSinceMidNight(B1, Mins_B1),
    minutesSinceMidNight(E1, Mins_E1),
    minutesSinceMidNight(B2, Mins_B2),
    minutesSinceMidNight(E2, Mins_E2),
    distanceOfIntervals([Mins_B1, Mins_E1], [Mins_B2, Mins_E2], D).

teacher(T)         :- teacherSubjects(T, _).
teaches(T, S)      :- teacherSubjects(T, L), member(S, L).
exam(S, D, [B, E]) :- examNeeds(S, D, [B, E], _).


% These are auxiliary predicates that you do not need to pay attention to.
distanceOfIntervals([B1, E1], [B2, E2], 0) :- B1 =< E2, B2 =< E1,    !.
distanceOfIntervals([B1,  _], [ _, E2], D) :- B1 > E2, D is B1 - E2, !.
distanceOfIntervals([ _, E1], [B2,  _], D) :- B2 > E1, D is B2 - E1, !.

minutesSinceMidNight(HH:MM, Mins) :- Mins is HH * 60 + MM.

%%%%%%% End helpful definitions ===============================================================


%%%%%%%  1. Declare SAT variables to be used: =================================================

% x(T, S, D, [B, E])  meaning  "teacher T invigilates the exam of subject S on date D from B to E".
satVariable( x(T, S, D, [B, E]) ) :- teacher(T), exam(S, D, [B, E]).


%%%%%%%  2. Clause generation for the SAT solver: =============================================

% This predicate writeClauses(MaxCost) generates the clauses that guarantee that
% a solution with cost at most MaxCost is found

writeClauses(infinite) :- !, findall(_, exam(_, _, _), L), length(L, N), writeClauses(N),!.
writeClauses(MaxInvigilations) :-
    notMoreInvigilationsPerTeacherThanAllowed(MaxInvigilations), %% TO BE COMPLETED
    eachExamHasRequiredNumberOfInvigilators,                     %% TO BE COMPLETED
    thereIsEnoughTimeBetweenInvigilationsOnSameDay,              %% TO BE COMPLETED
    onlyExternalInvigilatorsIfNeeded,                            %% TO BE COMPLETED
    canInvigilateAsExternalAtMostOnce,                           %% TO BE COMPLETED
    true,!.
writeClauses(_) :- told, nl, write('writeClauses failed!'), nl,nl, halt.


notMoreInvigilationsPerTeacherThanAllowed(MaxInvigilations) :-
    %% TO BE COMPLETED
    ...
notMoreInvigilationsPerTeacherThanAllowed(_).


eachExamHasRequiredNumberOfInvigilators :-
    %% TO BE COMPLETED
    ...
eachExamHasRequiredNumberOfInvigilators.


thereIsEnoughTimeBetweenInvigilationsOnSameDay :-
    %% TO BE COMPLETED
    ...
thereIsEnoughTimeBetweenInvigilationsOnSameDay.


onlyExternalInvigilatorsIfNeeded :-
    exam(S, D, [B, E]),
    teacher(T),
    not( teaches(T, S) ),
    %% TO BE COMPLETED
    ...
onlyExternalInvigilatorsIfNeeded.


canInvigilateAsExternalAtMostOnce :-
    %% TO BE COMPLETED
    ...
canInvigilateAsExternalAtMostOnce.


%%%%%%%  3. DisplaySol: this predicate displays a given solution M: ===========================

displaySol(M) :-
    nl,
    exam(S, D, [B, E]),
    findall(T, member(x(T, S, D, [B, E]), M), I),
    writeExam(S, D, [B, E]), write(': '), write(I),
    nl, fail.
displaySol(_).

writeExam(S, D, [B, E]) :-
    write('Exam of '),  write(S), write(' on '), my_write(D),
    write(' from '), my_write(B), write(' to '), my_write(E).
    
my_write(D/M/Y) :- my_write(D), write('/'), my_write(M), write('/'), my_write(Y), !.
my_write([B,E]) :- write('['), my_write(B), write(','), my_write(E), write(']'), !.
my_write(H:M) :- my_write(H), write(':'), my_write(M), !.
my_write(X) :- integer(X), X < 10, write(0), write(X), !.
my_write(X) :- write(X).

%%%%%%%  4. This predicate computes the cost of a given solution M: ===========================

invigilationsNumber(M, T, N) :-
    teacher(T),
    findall(_, member(x(T, _, _, _), M), L),
    length(L, N).

costOfThisSolution(M, Cost) :-
    %% TO BE COMPLETED
    ...

%%%%%%% =======================================================================================



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Everything below is given as a standard library, reusable for solving
%%    with SAT many different problems.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%% Cardinality constraints on arbitrary sets of literals Lits: ===========================

exactly(K,Lits) :- symbolicOutput(1), write( exactly(K,Lits) ), nl, !.
exactly(K,Lits) :- atLeast(K,Lits), atMost(K,Lits),!.

atMost(K,Lits) :- symbolicOutput(1), write( atMost(K,Lits) ), nl, !.
atMost(K,_) :- K < 0, writeOneClause([]), !.
atMost(K,Lits) :-   % l1+...+ln <= k:  in all subsets of size k+1, at least one is false:
      negateAll(Lits,NLits),
      K1 is K+1,    subsetOfSize(K1,NLits,Clause), writeOneClause(Clause),fail.
atMost(_,_).

atLeast(K,Lits) :- symbolicOutput(1), write( atLeast(K,Lits) ), nl, !.
atLeast(K,Lits) :- length(Lits,N), K > N, writeOneClause([]), !.
atLeast(K,Lits) :-  % l1+...+ln >= k: in all subsets of size n-k+1, at least one is true:
      length(Lits,N),
      K1 is N-K+1,  subsetOfSize(K1, Lits,Clause), writeOneClause(Clause),fail.
atLeast(_,_).

negateAll( [], [] ).
negateAll( [Lit|Lits], [NLit|NLits] ) :- negate(Lit,NLit), negateAll( Lits, NLits ),!.

negate( -Var,  Var) :- !.
negate(  Var, -Var) :- !.

subsetOfSize(0,_,[]) :- !.
subsetOfSize(N,[X|L],[X|S]) :- N1 is N-1, length(L,Leng), Leng>=N1, subsetOfSize(N1,L,S).
subsetOfSize(N,[_|L],   S ) :-            length(L,Leng), Leng>=N,  subsetOfSize( N,L,S).


%%%%%%% Express equivalence between a variable and a disjunction or conjunction of literals ===

% Express that Var is equivalent to the disjunction of Lits:
expressOr( Var, Lits ) :- symbolicOutput(1), write( Var ), write(' <--> or('), write(Lits), write(')'), nl, !.
expressOr( Var, Lits ) :- member(Lit,Lits), negate(Lit,NLit), writeOneClause([ NLit, Var ]), fail.
expressOr( Var, Lits ) :- negate(Var,NVar), writeOneClause([ NVar | Lits ]),!.

%% expressOr(a,[x,y]) genera 3 clausulas (como en la Transformación de Tseitin):
%% a == x v y
%% x -> a       -x v a
%% y -> a       -y v a
%% a -> x v y   -a v x v y

% Express that Var is equivalent to the conjunction of Lits:
expressAnd( Var, Lits) :- symbolicOutput(1), write( Var ), write(' <--> and('), write(Lits), write(')'), nl, !.
expressAnd( Var, Lits) :- member(Lit,Lits), negate(Var,NVar), writeOneClause([ NVar, Lit ]), fail.
expressAnd( Var, Lits) :- findall(NLit, (member(Lit,Lits), negate(Lit,NLit)), NLits), writeOneClause([ Var | NLits]), !.


%%%%%%% main: =================================================================================

main :- current_prolog_flag(os_argv, Argv),
        nth0(1, Argv, InputFile),
        main(InputFile), !.
main :- write('Usage: $ ./<executable> <example>          or ?- main(<example>).'), nl, halt.

main(InputFile) :-
        symbolicOutput(1), !,
        consult(InputFile),
        writeClauses(infinite), halt.   % print the clauses in symbolic form and halt
main(InputFile) :-
        consult(InputFile),
        told, write('Looking for initial solution with arbitrary cost...'), nl,
        initClauseGeneration,
        tell(clauses), writeClauses(infinite), told,
        tell(header),  writeHeader, told,
        numVars(N), numClauses(C),
        write('Generated '), write(C), write(' clauses over '), write(N), write(' variables. '),nl,
        shell('cat header clauses > infile.cnf',_),
        write('Launching kissat...'), nl,
        shell('kissat -v infile.cnf > model', Result),  % if sat: Result=10; if unsat: Result=20.
        treatResult(Result,[]),!.

treatResult(20,[]       ) :- write('No solution exists.'), nl, halt.
treatResult(20,BestModel) :-
        nl,costOfThisSolution(BestModel,Cost), write('Unsatisfiable. So the optimal solution was this one with cost '),
        write(Cost), write(':'), nl, displaySol(BestModel), nl,nl,halt.
treatResult(10,_) :- %   shell('cat model',_),
        nl,write('Solution found '), flush_output,
        see(model), symbolicModel(M), seen,
        costOfThisSolution(M,Cost),
        write('with cost '), write(Cost), nl,nl,
        displaySol(M),
        Cost1 is Cost-1,   nl,nl,nl,nl,nl,  write('Now looking for solution with cost '), write(Cost1), write('...'), nl,
        initClauseGeneration, tell(clauses), writeClauses(Cost1), told,
        tell(header),  writeHeader,  told,
        numVars(N),numClauses(C),
        write('Generated '), write(C), write(' clauses over '), write(N), write(' variables. '),nl,
        shell('cat header clauses > infile.cnf',_),
        write('Launching kissat...'), nl,
        shell('kissat -v infile.cnf > model', Result),  % if sat: Result=10; if unsat: Result=20.
        treatResult(Result,M),!.
treatResult(_,_) :- write('cnf input error. Wrote something strange in your cnf?'), nl,nl, halt.


initClauseGeneration :-  %initialize all info about variables and clauses:
        retractall(numClauses(   _)),
        retractall(numVars(      _)),
        retractall(varNumber(_,_,_)),
        assert(numClauses( 0 )),
        assert(numVars(    0 )),     !.

writeOneClause([]) :- symbolicOutput(1),!, nl.
writeOneClause([]) :- countClause, write(0), nl.
writeOneClause([Lit|C]) :- w(Lit), writeOneClause(C),!.
w(-Var) :- symbolicOutput(1), satVariable(Var), write(-Var), write(' '),!.
w( Var) :- symbolicOutput(1), satVariable(Var), write( Var), write(' '),!.
w(-Var) :- satVariable(Var),  var2num(Var,N),   write(-), write(N), write(' '),!.
w( Var) :- satVariable(Var),  var2num(Var,N),             write(N), write(' '),!.
w( Lit) :- told, write('ERROR: generating clause with undeclared variable in literal '), write(Lit), nl,nl, halt.


% given the symbolic variable V, find its variable number N in the SAT solver:
:- dynamic(varNumber / 3).
var2num(V,N) :- hash_term(V,Key), existsOrCreate(V,Key,N),!.
existsOrCreate(V,Key,N) :- varNumber(Key,V,N),!.                            % V already existed with num N
existsOrCreate(V,Key,N) :- newVarNumber(N), assert(varNumber(Key,V,N)), !.  % otherwise, introduce new N for V

writeHeader :- numVars(N),numClauses(C), write('p cnf '),write(N), write(' '),write(C),nl.

countClause :-     retract( numClauses(N0) ), N is N0+1, assert( numClauses(N) ),!.
newVarNumber(N) :- retract( numVars(   N0) ), N is N0+1, assert(    numVars(N) ),!.

% Getting the symbolic model M from the output file:
symbolicModel(M) :- get_code(Char), readWord(Char,W), symbolicModel(M1), addIfPositiveInt(W,M1,M),!.
symbolicModel([]).
addIfPositiveInt(W,L,[Var|L]) :- W = [C|_], between(48,57,C), number_codes(N,W), N>0, varNumber(_,Var,N),!.
addIfPositiveInt(_,L,L).
readWord( 99,W) :- repeat, get_code(Ch), member(Ch,[-1,10]), !, get_code(Ch1), readWord(Ch1,W),!. % skip line starting w/ c
readWord(115,W) :- repeat, get_code(Ch), member(Ch,[-1,10]), !, get_code(Ch1), readWord(Ch1,W),!. % skip line starting w/ s
readWord( -1,_) :-!, fail. %end of file
readWord(C, []) :- member(C,[10,32]), !. % newline or white space marks end of word
readWord(Char,[Char|W]) :- get_code(Char1), readWord(Char1,W), !.

%%%%%%% =======================================================================================
