
%% ----------- [2.5 points] ---------- %%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% A void list is recursively defined as either the empty list ([]), or a list whose elements
% are void lists. 
%
% Define a predicate voidListSizes(L,S) that, given a void list L, is true when S is a list of
% integers whose I-th element (I starting at 0) is the number of lists (appearing recursively)
% in L that have size I.
% For example,
%
%   ?- voidListSizes([],S).         % 1 list of size 0
%   S = [1]
%
%   ?- voidListSizes([[],[]],S).    % 2 lists of size 0, 0 of size 1, and 1 of size 2
%   S = [2, 0, 1].
%
%   ?- voidListSizes([[],[[],[[[]]]]],S).
%   S = [3, 2, 2].
%
%   ?- voidListSizes([[[],[[],[],[]]],[],[]],S).
%   S = [6, 0, 1, 2].
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% voidListSizes(+L,?S) holds if
%     S is a list where the I-th element is the count of lists in L with size I.
voidListSizes([], [1]) :- !.
voidListSizes([X|Y], S) :-
    length(Y, LY),
    voidListSizes(X, SX),
    voidListSizes(Y, SYPartial),
    ...

% zeroList(+N, ?L) holds if
%     L is a list of N zeros.
% Examples:
%   ?- zeroList(4, L).
%   L = [0, 0, 0, 0].
...

% addAtLength(+I, +K, +S1, ?S2) holds if
%     S2 is S1 with K added at index I (indices starting at 0).
% Examples:
%   ?- addAtLength(2, -1, [1,2,3,4], S2).
%   S2 = [1, 2, 2, 4].
%   ?- addAtLength(5, 10, [1,2,3,4], S2).
%   S2 = [1, 2, 3, 4, 0, 10].
% Hint: DO NOT use nth0/4 because index I may not be valid in S1.
%       Use mergeSizes/4 of two lists instead.
addAtLength(I, K, S1, S2) :-
    ...

% mergeSizes(+S1, +S2, ?S) holds if
%     S is the element-wise sum of S1 and S2, extending with zeros as necessary, i.e., 
%     in case S1 and S2 have different lengths, the shorter one is extended with zeros,
%     and then the result S is such that S[i] = S1[i] + S2[i] for all valid indices i.
% Examples:
%   ?- mergeSizes([1,2,3], [10,20,30], S).
%   S = [11, 22, 33].
%   ?- mergeSizes([1,2], [10,20,30,40,50], S).
%   S = [11, 22, 30, 40, 50].
%   ?- mergeSizes([1,2,3], [], S).
%   S = [1, 2, 3].
mergeSizes(...) :-
    ...
...
