
%% ------------ [2.5 points] ------------ %%

/*
We will represent words as lists of atoms, e.g., the word baa will be represented 
as [b,a,a]. A PCP system is defined as a list of pairs of words over some alphabet, e.g.,

  1. [a, baa]
  2. [ab, aa]
  3. [bba, bb]

Given a PCP system instance like the above, which will be represented as the Prolog list 
S = [[[a], [b,a,a]], [[a,b],[a,a]], [[b,b,a],[b,b]]], we want to find a sequence of D
numbers N1, ..., ND in {1,2,3} such that the words formed by the left and right elements 
of the pairs are equal, i.e., the concatenation of S[N1][1], S[N2][1], ... S[ND][1] 
equals the concatenation of S[N1][2], S[N2][2], ... S[ND][2], where S[i][j] is the 
j-th element (1 <= j <= 2), of the i-th pair (1 <= i <= 3). In the example above, 
one solution is [3,2,3,1] (Depth = 4) since:

  Left side:  S[3][1] S[2][1] S[3][1] S[1][1] = bba · ab · bba · a   = bbaabbbaa
  Right side: S[3][2] S[2][2] S[3][2] S[1][2] = bb  · aa · bb  · baa = bbaabbbaa

The sequence [3,2,3,1] is called a solution of the PCP system S, while the word
corresponding to a solution is called a matching word. It is a well-known undecidable
problem to determine whether a given PCP system has a solution or not.

Notice that in the case when each left part is always shorter than the corresponding 
right part (or vice versa), no solution is possible. In this case, we say that the
PCP system is unbalanced.

Complete the following Prolog predicate runSystem to implement a PCP solver that, 
given the PCP system number N, finds a solution (if any) by exploring the tree of
applications up to depth D. The predicate should print the found solution (the sequence 
of indices) and the corresponding matching word. Also, implement the helper predicate 
balanced(N) that checks whether the PCP system N is balanced.
*/

% PCP system instances
% system(order number, list of pairs of words)
% system 1: No solution was found up to a depth of 1000
system(1, [S1,S2,S3])    :- S1 = [[a],[b,b,a]], S2 = [[a,b],[a,a]], S3 = [[b,b,a],[b,b]].
% system 2: There is a solution with D = 4.
system(2, [S1,S2,S3])    :- S1 = [[a],[b,a,a]], S2 = [[a,b],[a,a]], S3 = [[b,b,a],[b,b]].
% system 3: No solution possible due to unbalanced PCP instance
system(3, [S1,S2])       :- S1 = [[a,b],[a]], S2 = [[b,a],[b]].
% system 4: No solution was found up to a depth of 1000
system(4, [S1,S2])       :- S1 = [[a,b],[a]], S2 = [[b,a],[b,b]].
% system 5: There is a solution with D = 7
system(5, [S1,S2,S3])    :- S1 = [[b,a,a],[b]], S2 = [[a],[b,a,a]], S3 = [[b],[a,a]].
% system 6: There is a solution with D = 3
system(6,[S1,S2,S3,S4]) :- S1 = [[b,b],[b]], S2 = [[a],[a,a]], S3 = [[b,a],[a,b]], S4 = [[a,b],[b,b]].
% system 7: There is a solution with D = 1
system(7, [S1])          :- S1 = [[a,a,a,a],[a,a,a,a]].
% system 8: No solution possible due to unbalanced PCP instance
system(8, [S1,S2,S3])    :- S1 = [[a],[b,a]], S2 = [[b],[a,a]], S3 = [[b,b,a],[b,b,b,b]].
% system 9: There is a solution with D = 25
system(9, [S1,S2,S3,S4,S5]) :- 
    S1 = [[a,a],[a,a,b]], S2 = [[a],[b,a,b]], S3 = [[a,b,b,a,b],[b]],
    S4 = [[b],[a]], S5 = [[b,a,b,a],[b,b,b,b]].

% pcp(N): MAIN predicate to find a solution of PCP system N
pcp(N) :-
    \+ balanced(N), !,
    write('No solution possible due to unbalanced PCP instance'), nl, halt.
pcp(N) :-
    between(0, 1000, D),  % solution explored up to a maximum depth of 1000
    runSystem(N, D, [], [], []), !, halt.
pcp(_) :-
    write('No solution was found up to a depth of 1000'), nl, halt.

% balanced(N): true if the PCP instance N is balanced 
% (i.e., left part is not always shorter than right part or vice versa)
balanced(N) :-
    system(N, S),
    member([L1,R1], S), member([L2,R2], S),
    length(L1, LenL1), length(R1, LenR1),
    length(L2, LenL2), length(R2, LenR2),
    LenL1 >= LenR1, LenL2 =< LenR2, !.

% runSystem(N, D, OrderingSoFar, LeftWordSoFar, RightWordSoFar):
%   predicate to explore possible sequences of applications of up to D steps
%   that build LeftWordSoFar and RightWordSoFar using PCP instance N

% base case: found a solution
runSystem(_, 0, OrderingSoFar, Word, Word) :- 
    Word \= [],
    write('Solution found: '), write(OrderingSoFar), nl,
    write('Matching word:  '), write(Word), nl.
% recursive case (as a depth-first search of depth D): 
% try to apply each pair and continue building the words
runSystem(N, D, OrderingSoFar, LeftWordSoFar, RightWordSoFar) :-
    D > 0,
    system(N, S),
    % extend left and right words with pair at index I,
    % obtaining NewLeftWordSoFar and NewRightWordSoFar
    nth1(I, S, [L, R]),
    append(LeftWordSoFar, L, NewLeftWordSoFar),
    append(RightWordSoFar, R, NewRightWordSoFar),
    oneIsPrefix(NewLeftWordSoFar, NewRightWordSoFar),  
    append(OrderingSoFar, [I], NewOrderingSoFar),
    NewD is D - 1,
    runSystem(N, NewD, NewOrderingSoFar, NewLeftWordSoFar, NewRightWordSoFar).

% helper predicate to check if one of the lists is a prefix of the other
% oneIsPrefix(List1, List2): true if List1 is a prefix of List2 or vice versa
oneIsPrefix([], _).
oneIsPrefix(_, []).
oneIsPrefix([H|T1], [H|T2]) :- oneIsPrefix(T1, T2), !. 

