/*
Label the N vertices of a tree with the integers 0,...,N-1
using a different integer for each vertex. Then, label
the edges with the absolute difference of the labels of their
incident vertices. Such a labeling is said to be graceful if all
the edges are labeled 1 through N-1 without repetitions. It is an
open problem whether every tree admits a graceful labeling.

Extend this Prolog source so that the predicate main(I) finds 
a graceful labeling for the tree in example I (any one is valid as 
long as it is graceful). In all examples, if the edge list contains 
M=N-1 edges, then the tree vertices are 1,...,N.

For example:
tree(1, [[1,2],[1,3],[3,4],[1,5],[5,6],[6,7]]).   % 6 edges, N=6+1=7 vertices

?- main(1).
vertex:label    1:0 2:2 3:3 4:4 5:6 6:1 7:5
 
         tree          label the vertices 0..N-1    label the edges
           1                    1:0                      1:0                
       /   |   \             /   |   \               2/  3|  6\   
      2    3    5    ==>   2:2  3:3  5:6    ==>    2:2   3:3   5:6
           |    |                |    |                  1|    5| 
           4    6               4:4  6:1                 4:4   6:1
                |                     |                        4| 
                7                    7:5                       7:5

In this instance, the edges are labeled 1 through N-1 without repetition,
so 1:0 2:2 3:3 4:4 5:6 6:1 7:5 is a graceful labeling.
Instead, the labeling 1:1 2:2 3:3 4:4 5:6 6:0 7:5 illustrated below is not graceful.
For example, because [1,2] and [3,4] are edges labeled with 1:

         tree          label the vertices 0..N-1    label the edges
           1                    1:1                      1:1                
       /   |   \             /   |   \              *1/  2| *5\   
      2    3    5    ==>   2:2  3:3  5:6    ==>    2:2   3:3   5:6
           |    |                |    |                 *1|    6| 
           4    6               4:4  6:0                 4:4   6:0
                |                     |                       *5| 
                7                    7:5                       7:5

Hint:
  1. Generate the list of all pairs of different edges from the edge list.
  2. Define and use a predicate that, given the previously generated
     list of pairs of edges, adds the constraints stating that
     the absolute differences of the labels assigned to the endpoints
     of the two edges in every pair are distinct.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*/


% tree(example number, edge list)
tree(1, [[1,2],[1,3],[3,4],[1,5],[5,6],[6,7]]).   % M=6 edges, N=7 vertices
tree(2, [[1,2],[1,4],[1,10],[2,3],[4,5],[4,7],[5,6],[7,8],[8,9]]).
tree(3, [[1,2],[1,3],[2,4],[2,5],[3,6],[3,7],[4,8],[5,9],[6,10],[7,11]]).

:- use_module(library(clpfd)).

%% Use the predicate main/1 to invoke the program with the example I.
main(I) :-
    graceful(I, _), !, halt.

%% Our external solution checker will use the second argument in graceful/2 to check your solution.
graceful(I, Lab) :-
    tree(I,Edges),
    length(Edges,M),
    N is M + 1,
    length(Lab,N),    % Lab = [L1,...,LN], where Li is the label of vertex i
    Lab ins 0..M,
    all_different(Lab),
    findall( [E1,E2], (append(_,[E1|Rest],Edges), member(E2,Rest)), EdgePairs ),
                      % EdgePairs are all pairs of different edges
    distinct(EdgePairs,Lab),
    label(Lab),
    writeSolution(Lab), nl.

distinct([],_).
distinct([[[I,J],[K,L]]|R],Lab) :-
    nth1(I,Lab,LI),
    nth1(J,Lab,LJ),
    nth1(K,Lab,LK),
    nth1(L,Lab,LL),
    abs(LI-LJ) #\= abs(LK-LL),
    distinct(R,Lab).

writeSolution(_) :-
    write("vertex:label  "), fail.
writeSolution(Lab) :-
    nth1(I,Lab,X),
    write(I:X), write(" "), fail.
writeSolution(_).
