
%% ----------- [2.5 points] ---------- %%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The Recamán's sequence is defined as follows: a(0) = 0; for n > 0, a(n) = a(n-1) - n if
% the result is strictly positive and not already in the sequence; otherwise, a(n) = a(n-1) + n.
%
% It's been conjectured that the sequence contains every positive integer,
% but the conjecture is still open.
%
% Define a predicate recaman(+N,?S) that is true when S is the list of the first N elements
% of the Recamán's sequence. For example,
%
%   ?- recaman(0,S).
%   S = [].
%
%   ?- recaman(1,S).
%   S = [0].
%
%   ?- recaman(10,S).
%   S = [0, 1, 3, 6, 2, 7, 13, 20, 12, 21].
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% recaman(+N,?S) holds if
%     S is the list of the first N elements of the Recamán's sequence
recaman(0, []) :- !.
recaman(N, S) :-
    N > 0,
    N1 is N - 1,
    recaman(N1, S1),
    lastElement(S1, APrev),
    trySubtract(APrev, N1, S1, A),
    append(S1, [A], S).

% lastElement(+L, ?X) holds if
%     X is the last element of L, or 0 if L is empty
lastElement([], 0) :- !.
lastElement(X, Y) :-
    last(X, Y).

% trySubtract(+APrev, +N, +S1, ?A) holds if
%     A is APrev - N when the result is strictly positive and not already in S1;
%     otherwise, A is APrev + N
% Examples:
%   ?- trySubtract(0, 1, [0], N).
%   N = 1.
%   ?- trySubtract(1, 2, [0, 1], N).
%   N = 3.
%   ?- trySubtract(6, 4, [0, 1, 3, 6], N).
%   N = 2.
trySubtract(APrev, N, S1, A) :-
    A is APrev - N,
    A > 0,
    \+ member(A, S1), !.
trySubtract(APrev, N, _, A) :-
    A is APrev + N.
