
%% ----------- [5 points] ---------- %%


symbolicOutput(0).  % set to 1 for DEBUGGING: to see symbolic output only; 0 otherwise.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BELOW IS A SOLUTION FOR A **SIMPLIFIED VERSION** OF THE "BOULEVARD PROBLEM", WHICH YOU
%% ALREADY KNOW. SOME OF THE "BOULEVARD REQUIREMENTS" HAVE BEEN **REMOVED**, AND THE
%% SAT-VARIABLE treeUsed(T) IS NO LONGER USED.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% SIMPLIFIED VERSION OF THE BOULEVARD PROBLEM:
%%
%% Your hometown is building a new avenue and it requires some trees.
%% There are three types of trees required:
%%  'shadow'    (s) are shadow trees with big leafs for summer, 
%%  'flowering' (f) are flowering trees that are beautiful in spring and have a good smell,
%%  'evergreen' (e) are evergreen trees so that the place will look green in winter as well.
%% We call a tree nursery and they give us a list of available trees with 3 parameters:
%% [type, size, cost] with the tree type, sizes of tree (small, medium or large),
%% and the cost of the tree, an integer.
%% Small trees cover 2m (2 meters), medium trees cover 4m, and large trees cover 6m
%% of the avenue.
%% A tree located at "start place" P, and size S, covers the places P,P+1,...,P+S-1.
%% No place on the avenue can be covered by more than one tree.
%% Additionally, no tree can cover outside the avenue's boundaries.
%% Two or more trees are said to be "adjacent" if they cover a list of consecutive places,
%% so there is no extra space between them. For example, the trees D and G in the solution
%% below are considered adjacent trees.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% IN THIS EXAM, **COMPLETE THE SOLUTION BELOW** TO MEET THESE **NEW** REQUIREMENTS:
%% - Trees that exceed some maximum price will be discarded.
%% - Two consecutive trees can be separated by no more than one extra space.
%%   Additionally, at most one extra space may be present either before the first
%%   tree or after the last tree.
%% - It is necessary to spread out small trees so they cannot be *adjacent*.
%%   For example, the consecutive small trees H and I in the solution below
%%   are NOT considered adjacent, due to the uncovered place 13. 
%% - The first tree and the last tree on the avenue must be of type 'flowering.'
%%   Note that not necessarily the first and last *places* have to be covered
%%   by this type of tree, as shown in place 20 of the solution.
%%
%% Some "helpful definitions" has been added.
%%
%% Given the avenue length, a maximum cost for a single tree, and the sequence of available
%% trees, find a solution for the avenue.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%% Begin INPUT in example avenueExampleA.pl %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% % avenueLength(Length).
%% avenueLength(20).

%% % maxCostOfOneTree(Cost).
%% maxCostOfOneTree(5).

%% % available(TreeId, [Type, Size, Cost]).
%% available('A', [shadow,    large,  10]). 
%% available('B', [flowering, large,  11]). 
%% available('C', [flowering, small,   2]). 
%% available('D', [shadow,    medium,  5]).
%% available('E', [evergreen, large,  10]).
%% available('F', [evergreen, large,   8]). 
%% available('G', [evergreen, medium,  4]). 
%% available('H', [evergreen, small,   1]). 
%% available('I', [shadow,    small,   1]). 
%% available('J', [flowering, medium,  5]). 

%%%%%%% End INPUT in example avenueExampleA.pl  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Example of OUTPUT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%          1         2
%% 12345678901234567890
%% C D   G   H  I J    
%% ffsssseeeeee.ssffff.     
%%
%% ==== Detailed information: ====
%%
%% tree C: type=flowering size=2 placed/start=[1] end=[2] cost=2
%% tree D: type=shadow size=4 placed/start=[3] end=[6] cost=5
%% tree G: type=evergreen size=4 placed/start=[7] end=[10] cost=4
%% tree H: type=evergreen size=2 placed/start=[11] end=[12] cost=1
%% tree I: type=shadow size=2 placed/start=[14] end=[15] cost=1
%% tree J: type=flowering size=4 placed/start=[16] end=[19] cost=5
%% trees [A,B,E,F]: not used
%%
%% NOTE on how the solution is shown:
%%      the character '!' at some place means that there are *more than one tree*
%%      covering that place. If these characters are present, that solution is not valid.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%% Some helpful definitions to make the code cleaner: ====================================

avenuePlace(P) :- avenueLength(L), between(1,L,P).

tree(T)          :- available(T,_).
treeType(T,Type) :- available(T,[Type,_,_]).
treeSize(T,2)    :- available(T,[_,small,_]).
treeSize(T,4)    :- available(T,[_,medium,_]).
treeSize(T,6)    :- available(T,[_,large,_]).
treeCost(T,Cost) :- available(T,[_,_,Cost]).

%% ADDED TO THIS EXAM: %%
twoConsecutivePlaces(P1,P2)   :- avenuePlace(P1), P2 is P1+1, avenuePlace(P2).
twoDifferentSmallTrees(T1,T2) :- treeSize(T1,2), treeSize(T2,2), T1 \= T2.

%%%%%%% End helpful definitions ===============================================================


%%%%%%%  1. Declare SAT variables to be used: =================================================

% SAT variable treeStart(T,P) means "tree T starts at place P (P is the leftmost position it covers)"
satVariable( treeStart(T,P) ) :- tree(T), avenuePlace(P).
% SAT variable covered(P)     means "place P is covered by some tree"
satVariable( covered(P)     ) :- avenuePlace(P).


%%%%%%%  2. Clause generation for the SAT solver: =============================================

writeClauses :-
    % Each tree can be placed/starts at most once on the avenue:
    eachTreeAtMostOneStartPlace,
    % Each place on the avenue at most "starts" one tree:
    eachStartPlaceAtMostOneTree,
    % "No tree can cover outside the avenue's boundaries":
    noTreeCoverOutsideBoundaries,
    % "No place on the avenue can be covered by more than one tree":
    leaveEnoughDistanceBetweenDifferentStarts,
    % Relate "covered" SAT var with "treeStart" SAT var:
    defineCoveredSATvar,

    %% ADDED FOR THIS EXAM: %%
    % "Trees that exceed some maximum price for a single tree will be excluded":
    noTreeWithExcessiveCost,
    % "Two consecutive trees may be separated by no more than one extra space":
    noTwoConsecutivePlacesUncovered,
    % "spread out small trees":
    noTwoAdjacentSmallTrees,
    % "The first and last tree on the avenue must be of type 'flowering'":
    firstTreeIsFlowering,
    lastTreeIsFlowering,
    true, !.
writeClauses:- told, nl, write('writeClauses failed!'), nl,nl, halt.

%% Each tree can be placed/starts at most once on the avenue:
eachTreeAtMostOneStartPlace :-
    tree(T),
    findall( treeStart(T,P), avenuePlace(P), Lits ),
    atMost(1,Lits),
    fail.
eachTreeAtMostOneStartPlace.

%% Each place on the avenue at most "starts" one tree:
eachStartPlaceAtMostOneTree :-
    avenuePlace(P),
    findall( treeStart(T,P), tree(T), Lits ),
    atMost(1,Lits),
    fail.
eachStartPlaceAtMostOneTree.

% "No tree can cover outside the avenue's boundaries":
noTreeCoverOutsideBoundaries :-
    avenueLength(L),
    treeSize(T,Size),
    FirstStart is L-Size+2,
    between(FirstStart,L,P),
    writeOneClause([-treeStart(T,P)]),
    fail.
noTreeCoverOutsideBoundaries.

%% "No place on the avenue can be covered by more than one tree":
leaveEnoughDistanceBetweenDifferentStarts :-
    avenuePlace(P1), avenuePlace(P2),
    P1 < P2,
    tree(T1), tree(T2),
    T1 \= T2,       % Given that "eachTreeAtMostOneStartPlace" guarantees that T1 and T2
    %%              % cannot be the same tree at two distinct start locations, T1 \= T2
    %%              % may be removed, but adding it produces fewer clauses.
    treeSize(T1,Size),
    P2 < P1+Size,
    writeOneClause([-treeStart(T1,P1),-treeStart(T2,P2)]),
    fail.
leaveEnoughDistanceBetweenDifferentStarts.

%% Relate "covered" SAT var with "treeStart" SAT var:
defineCoveredSATvar :-
    avenuePlace(P),
    findall( treeStart(T,Pt), (treeSize(T,S), S1 is S-1, between(0,S1,DP), Pt is P-DP, avenuePlace(Pt)), Lits ),    
    expressOr(covered(P), Lits),
    fail.
defineCoveredSATvar.

%% BEGIN OF NEW IN THIS EXAM: %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% "Trees that exceed some maximum price will be discarded".
noTreeWithExcessiveCost :-
    %% COMPLETE 1/5:
    %% ...
    maxCostOfOneTree(MaxCost),
    treeCost(T, Cost),
    Cost > MaxCost,
    avenuePlace(P),
    writeOneClause( [-treeStart(T,P)] ),
    fail.
noTreeWithExcessiveCost.
    
%% "Two consecutive trees may be separated by no more than one extra space".
noTwoConsecutivePlacesUncovered :-
    %% COMPLETE 2/5:
    %% ...
    twoConsecutivePlaces(P1, P2),
    writeOneClause( [covered(P1), covered(P2)] ),    %% also: atLeast(1, [covered(P1), covered(P2)])
    fail.
noTwoConsecutivePlacesUncovered.

%% "Spread out small trees":
noTwoAdjacentSmallTrees :-
    %% COMPLETE 3/5:
    %% ...
    avenuePlace(P1), P2 is P1 + 2, avenuePlace(P2),
    twoDifferentSmallTrees(T1, T2),
    writeOneClause( [-treeStart(T1,P1), -treeStart(T2,P2)] ),
    fail.
noTwoAdjacentSmallTrees.

%% "The first tree on the avenue must be of type 'flowering'":
firstTreeIsFlowering :-
    %% COMPLETE 4/5:
    %% ...
    findall( treeStart(T,P), (treeType(T,flowering), between(1,2,P), avenuePlace(P)), Lits ),
    writeOneClause(Lits),    %% also: exactly(1, Lits)
    fail.
firstTreeIsFlowering.

%% "The last tree on the avenue must be of type 'flowering'":
lastTreeIsFlowering :-
    avenueLength(L),
    P2 is L-2, P1 is L-1,
    %% COMPLETE 5/5:
    %% findall( ..., ( ... ), LitsS ),
    %% ...
    findall(treeStart(T,P), (treeType(T,flowering), treeSize(T,2), between(P2,P1,P)), LitsS),
    P4 is L-4, P3 is L-3,
    findall(treeStart(T,P), (treeType(T,flowering), treeSize(T,4), between(P4,P3,P)), LitsM),
    P6 is L-6, P5 is L-5,
    findall(treeStart(T,P), (treeType(T,flowering), treeSize(T,6), between(P6,P5,P)), LitsL),
    append([LitsS,LitsM,LitsL], Lits),
    writeOneClause(Lits),    %% atLeast(1, Lits)
    fail.
lastTreeIsFlowering.

%% END OF NEW IN THIS EXAM: %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%  3. DisplaySol: this predicate displays a given solution M: ===========================

%displaySol(M) :- write(M), nl, nl, fail.
displaySol(_) :- nl, avenueLength(L), write('%% '), between(1,L,N), (0 is N mod 10 -> Q is N div 10, write(Q) ; write(' ')), fail.
displaySol(_) :- nl, write('%% '), avenueLength(L), between(1,L,N), R is N mod 10, write(R), fail.
displaySol(M) :- nl, write('%% '), avenuePlace(P), writeTreeAtPlace(P,M), fail.
displaySol(M) :- nl, write('%% '), avenuePlace(P), writeTreeTypeAtPlace(P,M), fail.
displaySol(M) :- avenueLength(L), L1 is L+1 , L5 is L+5, between(L1,L5,P),
                 writeTreeTypeAtPastEndPlace(P,M), fail.
displaySol(_).

write2(N) :- N < 10, !, write(' '), write(N).
write2(N) :- write(N).

writeTreeAtPlace(P,M) :-
    findall( T, member(treeStart(T,P),M), L),
    ( L = []  -> write(' ') ; ( L = [T1] -> write(T1) ; write('!') ) ).

writeTreeTypeAtPlace(P,M) :-
    findall( T, (member(treeStart(T,P1),M),P1=<P,treeSize(T,Size),P1+Size>P), L),
    ( L = [] -> write('.') ; ( L = [T1] -> treeType(T1,Type), writeType(Type) ; write('!') ) ).

writeTreeTypeAtPastEndPlace(P,M) :-
    findall( T, (member(treeStart(T,P1),M),treeSize(T,Size),P1+Size>P), L),
    ( L = [] -> write(' ') ; ( L = [T1] -> treeType(T1,Type), writeType(Type) ; write('!') ) ).

writeType(shadow)    :- write('s').
writeType(flowering) :- write('f').
writeType(evergreen) :- write('e').

displaySolDetails(_) :- nl, nl, write('==== Detailed information: ===='), fail.
displaySolDetails(M) :- nl, tree(T), findall(P, (avenuePlace(P), member(treeStart(T,P),M)), L),
                        L \= [],
                        nl, write('tree '), write(T),
                        write(': type='), treeType(T,Type), write(Type),
                        write(' size='), treeSize(T,S), write(S),
                        write(' placed/start='), write(L),
                        findall(Pe, (member(P,L), Pe is P+S-1), Le),
                        write(' end='), write(Le),
                        write(' cost='), treeCost(T,C), write(C),
                        fail.
displaySolDetails(M) :- findall(T, (tree(T), findall(P, (avenuePlace(P), member(treeStart(T,P),M)), L), L == []), LT),
                        LT \= [],
                        nl, write('trees '), write(LT), write(': not used'), nl,
			fail.
displaySolDetails(_).


%%%%%%% =======================================================================================



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Everything below is given as a standard library, reusable for solving
%%    with SAT many different problems.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%% Cardinality constraints on arbitrary sets of literals Lits: ===========================

exactly(K,Lits) :- symbolicOutput(1), write( exactly(K,Lits) ), nl, !.
exactly(K,Lits) :- atLeast(K,Lits), atMost(K,Lits),!.

atMost(K,Lits) :- symbolicOutput(1), write( atMost(K,Lits) ), nl, !.
atMost(K,Lits) :-   % l1+...+ln <= k:  in all subsets of size k+1, at least one is false:
      negateAll(Lits,NLits),
      K1 is K+1,    subsetOfSize(K1,NLits,Clause), writeOneClause(Clause),fail.
atMost(_,_).

atLeast(K,Lits) :- symbolicOutput(1), write( atLeast(K,Lits) ), nl, !.
atLeast(K,Lits) :-  % l1+...+ln >= k: in all subsets of size n-k+1, at least one is true:
      length(Lits,N),
      K1 is N-K+1,  subsetOfSize(K1, Lits,Clause), writeOneClause(Clause),fail.
atLeast(_,_).

negateAll( [], [] ).
negateAll( [Lit|Lits], [NLit|NLits] ) :- negate(Lit,NLit), negateAll( Lits, NLits ),!.

negate( -Var,  Var) :- !.
negate(  Var, -Var) :- !.

subsetOfSize(0,_,[]) :- !.
subsetOfSize(N,[X|L],[X|S]) :- N1 is N-1, length(L,Leng), Leng>=N1, subsetOfSize(N1,L,S).
subsetOfSize(N,[_|L],   S ) :-            length(L,Leng), Leng>=N,  subsetOfSize( N,L,S).


%%%%%%% Express equivalence between a variable and a disjunction or conjunction of literals ===

% Express that Var is equivalent to the disjunction of Lits:
expressOr( Var, Lits ) :- symbolicOutput(1), write( Var ), write(' <--> or('), write(Lits), write(')'), nl, !.
expressOr( Var, Lits ) :- member(Lit,Lits), negate(Lit,NLit), writeOneClause([ NLit, Var ]), fail.
expressOr( Var, Lits ) :- negate(Var,NVar), writeOneClause([ NVar | Lits ]),!.

%% expressOr(a,[x,y]) genera 3 clausulas (como en la Transformación de Tseitin):
%% a == x v y
%% x -> a       -x v a
%% y -> a       -y v a
%% a -> x v y   -a v x v y

% Express that Var is equivalent to the conjunction of Lits:
expressAnd( Var, Lits) :- symbolicOutput(1), write( Var ), write(' <--> and('), write(Lits), write(')'), nl, !.
expressAnd( Var, Lits) :- member(Lit,Lits), negate(Var,NVar), writeOneClause([ NVar, Lit ]), fail.
expressAnd( Var, Lits) :- findall(NLit, (member(Lit,Lits), negate(Lit,NLit)), NLits), writeOneClause([ Var | NLits]), !.


%%%%%%% main: =================================================================================

main :- current_prolog_flag(os_argv, Argv),
        nth0(1, Argv, InputFile),
        main(InputFile), !.
main :-  write('Usage: $ ./<executable> <example>          or ?- main(<example>).'), nl, halt.

main(InputFile) :-
        symbolicOutput(1), !,
        consult(InputFile),
        writeClauses, halt.   % print the clauses in symbolic form and halt Prolog
main(InputFile):-
        consult(InputFile),
        initClauseGeneration,
        tell(clauses), writeClauses, told,          % generate the (numeric) SAT clauses and call the solver
        tell(header),  writeHeader, told,
        numVars(N), numClauses(C),
        write('Generated '), write(C), write(' clauses over '), write(N), write(' variables. '),nl,
        shell('cat header clauses > infile.cnf',_),
        write('Calling solver....'), nl,
        shell('kissat -v infile.cnf > model', Result),  % if sat: Result=10; if unsat: Result=20.
        treatResult(Result),!.

treatResult(20) :- write('Unsatisfiable'), nl, halt.
treatResult(10) :- write('Solution found: '), nl, see(model), symbolicModel(M), seen, displaySol(M), displaySolDetails(M), nl,nl,halt.
treatResult( _) :- write('cnf input error. Wrote anything strange in your cnf?'), nl,nl, halt.


initClauseGeneration:-  %initialize all info about variables and clauses:
        retractall(numClauses(   _)),
        retractall(numVars(      _)),
        retractall(varNumber(_,_,_)),
        assert(numClauses( 0 )),
        assert(numVars(    0 )),     !.

writeOneClause([]) :- symbolicOutput(1),!, nl.
writeOneClause([]) :- countClause, write(0), nl.
writeOneClause([Lit|C]) :- w(Lit), writeOneClause(C),!.
w(-Var) :- symbolicOutput(1), satVariable(Var), write(-Var), write(' '),!.
w( Var) :- symbolicOutput(1), satVariable(Var), write( Var), write(' '),!.
w(-Var) :- satVariable(Var),  var2num(Var,N),   write(-), write(N), write(' '),!.
w( Var) :- satVariable(Var),  var2num(Var,N),             write(N), write(' '),!.
w( Lit) :- told, write('ERROR: generating clause with undeclared variable in literal '), write(Lit), nl,nl, halt.


% given the symbolic variable V, find its variable number N in the SAT solver:
:- dynamic(varNumber / 3).
var2num(V,N) :- hash_term(V,Key), existsOrCreate(V,Key,N),!.
existsOrCreate(V,Key,N) :- varNumber(Key,V,N),!.                            % V already existed with num N
existsOrCreate(V,Key,N) :- newVarNumber(N), assert(varNumber(Key,V,N)), !.  % otherwise, introduce new N for V

writeHeader :- numVars(N),numClauses(C), write('p cnf '),write(N), write(' '),write(C),nl.

countClause :-     retract( numClauses(N0) ), N is N0+1, assert( numClauses(N) ),!.
newVarNumber(N) :- retract( numVars(   N0) ), N is N0+1, assert(    numVars(N) ),!.

% Getting the symbolic model M from the output file:
symbolicModel(M) :- get_code(Char), readWord(Char,W), symbolicModel(M1), addIfPositiveInt(W,M1,M),!.
symbolicModel([]).
addIfPositiveInt(W,L,[Var|L]) :- W = [C|_], between(48,57,C), number_codes(N,W), N>0, varNumber(_,Var,N),!.
addIfPositiveInt(_,L,L).
readWord( 99,W) :- repeat, get_code(Ch), member(Ch,[-1,10]), !, get_code(Ch1), readWord(Ch1,W),!. % skip line starting w/ c
readWord(115,W) :- repeat, get_code(Ch), member(Ch,[-1,10]), !, get_code(Ch1), readWord(Ch1,W),!. % skip line starting w/ s
readWord( -1,_) :-!, fail. %end of file
readWord(C, []) :- member(C,[10,32]), !. % newline or white space marks end of word
readWord(Char,[Char|W]) :- get_code(Char1), readWord(Char1,W), !.

%%%%%%% =======================================================================================
