/*
 * Decompiled with CFR 0.152.
 */
package Tree;

import java.util.ArrayList;

public class TreeNode {
    public ArrayList children = new ArrayList(2);
    public int key;
    private int min;
    private int max;
    private int fontSize;
    Double bcnScore;
    int computedFrame;
    double midYPosition;
    public TreeNode parent;
    String name = "";
    public String label = "";
    int height;
    public float weight = 0.0f;
    public TreeNode leftmostLeaf;
    public TreeNode rightmostLeaf;
    public int numberLeaves;
    public TreeNode preorderNext = null;
    public TreeNode posorderNext = null;

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public boolean pick(int x, int y) {
        return false;
    }

    public TreeNode() {
        this.max = -1;
        this.min = Integer.MAX_VALUE;
        this.bcnScore = new Double(0.0);
    }

    public void close() {
        this.children.clear();
        this.children = null;
        this.name = null;
        this.parent = null;
        this.label = null;
        this.leftmostLeaf = null;
        this.rightmostLeaf = null;
        this.preorderNext = null;
        this.posorderNext = null;
        this.bcnScore = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public TreeNode(String s, float w) {
        this.name = new String(s);
        this.weight = w;
        this.max = -1;
        this.min = Integer.MAX_VALUE;
    }

    public TreeNode(String s) {
        this.name = new String(s);
        this.max = -1;
        this.min = Integer.MAX_VALUE;
    }

    public void setName(String s) {
        this.name = new String(s);
    }

    public int numberChildren() {
        return this.children.size();
    }

    public TreeNode getChild(int i) {
        return (TreeNode)this.children.get(i);
    }

    public TreeNode getLeftmostLeaf() {
        TreeNode n = this;
        while (!n.isLeaf()) {
            n = n.firstChild();
        }
        return n;
    }

    public TreeNode getRightmostLeaf() {
        TreeNode n = this;
        while (!n.isLeaf()) {
            n = n.lastChild();
        }
        return n;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getLeafCount() {
        if (this == null) {
            return 0;
        }
        if (this.isLeaf()) {
            return 1;
        }
        int sum = 0;
        int i = 0;
        while (i < this.numberChildren()) {
            sum += this.getChild(i).getLeafCount();
            ++i;
        }
        return sum;
    }

    public boolean equals(TreeNode n) {
        return this.name.equals(n.name);
    }

    public void addChild(TreeNode n) {
        this.children.add(n);
        n.parent = this;
    }

    public TreeNode parent() {
        return this.parent;
    }

    public void setWeight(double w) {
        this.weight = (float)w;
    }

    public float getWeight() {
        return this.weight;
    }

    public TreeNode firstChild() {
        return (TreeNode)this.children.get(0);
    }

    public TreeNode lastChild() {
        return (TreeNode)this.children.get(this.children.size() - 1);
    }

    public void removeChild(TreeNode n) {
        this.children.remove(this.children.indexOf(n));
    }

    public void updateParent(TreeNode n) {
        if (n.parent.parent != null) {
            int i = n.parent.parent.children.indexOf(n.parent);
            n.parent.parent.children.remove(i);
            n.parent.parent.children.add(i, n);
            n.parent = n.parent.parent;
        }
    }

    public void updateParent1(TreeNode n) {
        if (n.parent.parent != null) {
            int i = n.parent.parent.children.indexOf(n.parent);
            n.parent.parent.children.remove(i);
            n.parent.parent.children.add(i, n);
            n.parent = n.parent.parent;
        }
    }

    public void updateNode() {
        this.children.clear();
    }

    public void updateNode(TreeNode newNode) {
        this.children.clear();
        this.children.add(newNode);
    }

    public void updateSubTree(TreeNode n, TreeNode t1_n1) {
        n.children.remove(n.children.indexOf(t1_n1));
        if (n.numberChildren() < 2) {
            n.getChild(0).updateParent(n.getChild(0));
        }
        if (n.parent() != null && n.parent().getMin() < n.parent().getLeftmostLeaf().getKey()) {
            n.parent().setMin(n.parent().getLeftmostLeaf().getKey());
        }
        if (n.parent() != null && n.parent().getMax() > n.parent().getRightmostLeaf().getKey()) {
            n.parent().setMax(n.parent().getRightmostLeaf().getKey());
        }
        if (n.parent() != null && n.parent().getMax() < n.parent().getMin()) {
            n.parent().setMax(n.parent().getLeftmostLeaf().getKey());
            n.parent().setMin(n.parent().getRightmostLeaf().getKey());
        }
    }

    public void setMin(int newMin) {
        this.min = newMin;
    }

    public void setMax(int newMax) {
        this.max = newMax;
    }

    public void updateParentTrip(TreeNode n) {
        n.parent = n.parent.parent;
    }

    public void addChild(int i, TreeNode n) {
        this.children.add(i, n);
        n.parent = this;
    }

    public void print() {
        if (this.name != null) {
            System.out.print("node name: " + this.name + "\t");
        } else {
            System.out.print("node name null,\t");
        }
        System.out.println("key: " + this.key);
    }

    public void printSubtree() {
        int i = 0;
        while (i < this.children.size()) {
            System.out.println("child " + i + " " + this.getChild(i) + " " + this.getChild((int)i).parent + " " + this.getChild((int)i).parent.key);
            this.print();
            this.getChild(i).printSubtree();
            ++i;
        }
    }

    public void setSubtreeExtremeLeaves() {
        if (this.isLeaf()) {
            this.leftmostLeaf = this;
            this.rightmostLeaf = this;
            return;
        }
        int i = 0;
        while (i < this.children.size()) {
            this.getChild(i).setSubtreeExtremeLeaves();
            ++i;
        }
        this.leftmostLeaf = this.firstChild().leftmostLeaf;
        this.rightmostLeaf = this.lastChild().rightmostLeaf;
    }

    void setSubtreeMinMax() {
        if (this.isLeaf()) {
            this.min = this.key;
            this.max = this.key;
            return;
        }
        int i = 0;
        while (i < this.children.size()) {
            this.getChild(i).setSubtreeMinMax();
            int childMin = this.getChild((int)i).min;
            this.min = childMin < this.min ? childMin : this.min;
            int childMax = this.getChild((int)i).max;
            this.max = childMax > this.max ? childMax : this.max;
            ++i;
        }
    }

    int setSubtreeNumberLeaves() {
        this.numberLeaves = 0;
        if (this.isLeaf()) {
            this.numberLeaves = 1;
        } else {
            int i = 0;
            while (i < this.children.size()) {
                this.numberLeaves += this.getChild(i).setSubtreeNumberLeaves();
                ++i;
            }
        }
        return this.numberLeaves;
    }

    public String toString() {
        return String.valueOf(this.name) + "(" + this.key + " @ " + this.height + ")";
    }

    public void setFontSize(int fs) {
        this.fontSize = fs;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public boolean isInteriorNode() {
        return this.children.size() > 0;
    }

    public void setBcnScore(float n) {
        this.bcnScore = new Double(n);
    }

    public Double getBcnScore() {
        return this.bcnScore;
    }
}

