/*
 * Decompiled with CFR 0.152.
 */
package Tree;

import Parser.Newick;
import Parser.nexus.Nexus;
import Tree.NameComparator;
import Tree.TreeNode;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Tree {
    private TreeNode[] leaf;
    static Newick parser = new Newick(System.in);
    static Nexus parser_nexus = new Nexus(System.in);
    public ArrayList nodes;
    public ArrayList internalNodes = new ArrayList();
    public HashMap nodesByName;
    private int nodeCount;
    private int key;
    private int height = 0;
    String name = null;
    int number = 0;
    public TreeNode root = null;
    public TreeNode preorderStartNode;
    public TreeNode posorderStartNode;

    public Tree() {
        this.root = new TreeNode();
        this.nodes = new ArrayList();
        this.nodesByName = new HashMap();
    }

    public Tree(String tn) {
        this.name = new String(tn);
        this.root = new TreeNode();
    }

    public Tree(TreeNode rn) {
        this.root = rn;
    }

    public Tree(Tree t) {
        this.nodes = new ArrayList();
        this.nodesByName = new HashMap();
        TreeNode[] arraytemp = new TreeNode[t.getSize()];
        TreeNode n = t.posorderStartNode;
        while (n != null) {
            TreeNode myn;
            arraytemp[n.getKey()] = myn = new TreeNode(n.getName(), n.getWeight());
            int i = 0;
            while (i < n.numberChildren()) {
                TreeNode nkid = (TreeNode)n.children.get(i);
                myn.addChild(arraytemp[nkid.getKey()]);
                ++i;
            }
            n = n.posorderNext;
        }
        this.root = arraytemp[0];
        this.postProcess();
    }

    public void close() {
        TreeNode pren = this.root.leftmostLeaf;
        TreeNode n = pren.preorderNext;
        while (n != null) {
            n.close();
            n = n.preorderNext;
        }
        this.nodes = null;
        this.nodesByName = null;
        System.out.println("clean tree");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public void load(String fname) {
        this.setName(fname);
        try {
            FileInputStream in = new FileInputStream(fname);
            Newick.ReInit(in);
            parser.parseTree(this);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error! File " + fname + " not found!");
            System.exit(1);
        }
        this.postProcess();
    }

    public void load_nexus(String fname, int index) {
        this.setName(fname);
        this.number = index;
        try {
            FileInputStream in = new FileInputStream(fname);
            Nexus.ReInit(in);
            parser_nexus.parseTree(this, index);
            in = null;
            System.gc();
        }
        catch (FileNotFoundException e) {
            System.out.println("Error! File " + fname + " not found!");
            System.exit(1);
        }
        this.postProcess();
    }

    int getInteriorCount() {
        return this.nodeCount - this.leaf.length;
    }

    int getTotalNodeCount() {
        return this.nodeCount;
    }

    public TreeNode getNodeByKey(int key) {
        if (key >= this.nodes.size()) {
            return null;
        }
        return (TreeNode)this.nodes.get(key);
    }

    public TreeNode getNodeByName(String s) {
        return (TreeNode)this.nodesByName.get(s);
    }

    int getHeight() {
        return this.height;
    }

    public void setKey(int i) {
        this.key = i;
    }

    public int getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.nodeCount;
    }

    public TreeNode getLeftmostLeaf() {
        return this.root.leftmostLeaf;
    }

    public TreeNode getRightmostLeaf() {
        return this.root.rightmostLeaf;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    void setRoot(TreeNode rn) {
        this.root = rn;
    }

    void setName(String tn) {
        this.name = new String(tn);
    }

    void printName() {
        if (this.name != null) {
            System.out.println("Tree Name: " + this.name);
        }
    }

    public int getLeafCount() {
        return this.leaf.length;
    }

    public void postProcess() {
        this.root.setSubtreeExtremeLeaves();
        this.root.setSubtreeNumberLeaves();
        this.linkNodesInPreorder();
        this.linkNodesInPosorder();
        this.linkLeaves();
        this.root.setSubtreeMinMax();
    }

    public void deleteNode(TreeNode n1) {
        this.nodesByName.remove(n1.getName());
    }

    public void removeNode(TreeNode n) {
        n.parent().removeChild(n);
    }

    public void updateParentOfNode(TreeNode n) {
        n.updateParent(n);
    }

    public void updateNode_(TreeNode n) {
        n.updateParent1((TreeNode)n.children.get(0));
    }

    public void replaceNode(TreeNode n2) {
        this.nodesByName.remove(n2.getName());
        this.nodes.remove(n2);
        this.nodes.remove(n2.parent);
    }

    public void removeSP(TreeNode t1_n1) {
        this.nodesByName.remove(t1_n1.getName());
        t1_n1.updateNode();
        this.updateSub(t1_n1);
    }

    public void updateSub(TreeNode t1_n1) {
        if (t1_n1.numberChildren() == 0) {
            t1_n1.updateSubTree(t1_n1.parent(), t1_n1);
        }
    }

    public void case1_cutEdges(TreeNode n, TreeNode t2_n1, TreeNode t2_n2) {
        n.updateNode();
        n.parent().removeChild(n);
        n = n.parent.getChild(0);
        n.updateParent1(n);
        this.simplyUpdateTree(n);
    }

    public void updateHashMap() {
        HashMap nodesByNameDUP = this.nodesByName;
        this.nodesByName = new HashMap();
        TreeNode n = this.preorderStartNode;
        while (n != null) {
            if (!(n.toString().indexOf("(") != 0 && nodesByNameDUP.get(n.getName()) == null || n.toString().indexOf("(") == 0 && n.numberChildren() == 0 && n.isLeaf())) {
                this.nodesByName.put(n.getName(), n);
            }
            n = n.preorderNext;
        }
    }

    public void updateTree(TreeNode n, TreeNode newNode, TreeNode n2) {
        n.updateNode();
        n2.updateNode(newNode);
    }

    public void cutSP_adjust(TreeNode t2_n1, TreeNode t2_n2) {
        TreeNode n = t2_n1.parent();
        n.removeChild(t2_n1);
        n.updateParent(n.getChild(0));
        n = t2_n2.parent();
        n.removeChild(t2_n2);
        n.updateParent(n.getChild(0));
        this.simplyUpdateTree(n.getChild(0));
    }

    public void simplyUpdateTree(TreeNode n) {
        if (n.parent() != null && n.parent().getMin() < n.parent().getLeftmostLeaf().getKey()) {
            n.parent().setMin(n.parent().getLeftmostLeaf().getKey());
        }
        if (n.parent() != null && n.parent().getMax() > n.parent().getRightmostLeaf().getKey()) {
            n.parent().setMax(n.parent().getRightmostLeaf().getKey());
        }
        if (n.parent() != null && n.parent().getMax() < n.parent().getMin()) {
            n.parent().setMax(n.parent().getLeftmostLeaf().getKey());
            n.parent().setMin(n.parent().getRightmostLeaf().getKey());
        }
    }

    public void updateTree(TreeNode n, TreeNode newNode) {
        boolean parentLeafFLAG = false;
        n.updateNode(newNode);
        n.updateParent(newNode);
        if (n.parent() != null && n.parent().getMin() < n.parent().getLeftmostLeaf().getKey()) {
            n.parent().setMin(n.parent().getLeftmostLeaf().getKey());
        }
        if (n.parent() != null && n.parent().getMax() > n.parent().getRightmostLeaf().getKey()) {
            n.parent().setMax(n.parent().getRightmostLeaf().getKey());
        }
        if (n.parent() != null && n.parent().getMax() < n.parent().getMin()) {
            n.parent().setMax(n.parent().getLeftmostLeaf().getKey());
            n.parent().setMin(n.parent().getRightmostLeaf().getKey());
        }
    }

    public void getSubTree(TreeNode n) {
        System.out.println(n + " " + n.parent());
    }

    public ArrayList getInternalVertices() {
        ArrayList<TreeNode> iNodes = new ArrayList<TreeNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            TreeNode temp = (TreeNode)this.nodes.get(i);
            if (temp.label.length() == 0) {
                iNodes.add(temp);
            }
            ++i;
        }
        return iNodes;
    }

    public ArrayList getLeafNodes() {
        ArrayList<TreeNode> lNodes = new ArrayList<TreeNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            TreeNode temp = (TreeNode)this.nodes.get(i);
            if (temp.label.length() != 0) {
                lNodes.add(temp);
            }
            ++i;
        }
        return lNodes;
    }

    public ArrayList getInternalVerticesKeys() {
        ArrayList<String> iNodes = new ArrayList<String>();
        int i = 0;
        while (i < this.nodes.size()) {
            TreeNode temp = (TreeNode)this.nodes.get(i);
            if (temp.label.length() == 0) {
                iNodes.add(Integer.toString(temp.key));
            }
            ++i;
        }
        return iNodes;
    }

    private void linkNodesInPreorder() {
        int separator = 47;
        this.preorderStartNode = this.root;
        this.linkSubtreeNodesInPreorder(this.root);
        int index = 0;
        this.height = 1;
        TreeNode n = this.preorderStartNode;
        while (n != null) {
            n.label = n.name;
            n.key = index++;
            this.nodes.add(n);
            if (n.name.length() > 0) {
                this.nodesByName.put(n.name, n);
            }
            n.height = n.parent != null ? n.parent.height + 1 : 1;
            this.height = n.height > this.height ? n.height : this.height;
            n = n.preorderNext;
        }
        this.nodeCount = index;
    }

    private void linkSubtreeNodesInPreorder(TreeNode n) {
        if (n.isLeaf()) {
            return;
        }
        int i = 0;
        while (i < n.numberChildren()) {
            this.linkSubtreeNodesInPreorder(n.getChild(i));
            ++i;
        }
        n.preorderNext = n.firstChild();
        i = 0;
        while (i < n.numberChildren() - 1) {
            n.getChild((int)i).rightmostLeaf.preorderNext = n.getChild(i + 1);
            ++i;
        }
        n.rightmostLeaf.preorderNext = null;
    }

    private void linkNodesInPosorder() {
        this.posorderStartNode = this.root.leftmostLeaf;
        this.linkSubtreeNodesInPosorder(this.root);
    }

    private void linkSubtreeNodesInPosorder(TreeNode n) {
        if (n.isLeaf()) {
            return;
        }
        int i = 0;
        while (i < n.numberChildren()) {
            this.linkSubtreeNodesInPosorder(n.getChild(i));
            ++i;
        }
        n.posorderNext = null;
        i = 0;
        while (i < n.numberChildren() - 1) {
            n.getChild((int)i).posorderNext = n.getChild((int)(i + 1)).leftmostLeaf;
            ++i;
        }
        n.lastChild().posorderNext = n;
    }

    private void linkLeaves() {
        TreeNode pren = this.root.leftmostLeaf;
        Vector<TreeNode> leaves = new Vector<TreeNode>();
        leaves.add(pren);
        TreeNode n = pren.preorderNext;
        while (n != null) {
            if (n.isLeaf()) {
                leaves.add(n);
            }
            n = n.preorderNext;
        }
        this.leaf = leaves.toArray(new TreeNode[leaves.size()]);
        NameComparator myNameComparator = new NameComparator();
        TreeNode[] sortedLeafArray = leaves.toArray(new TreeNode[leaves.size()]);
        Arrays.sort(sortedLeafArray, myNameComparator);
        int index = 0;
        TreeNode curr = sortedLeafArray[0];
        int i = 0;
        while (i < leaves.size() - 1) {
            boolean compare;
            TreeNode next = sortedLeafArray[i + 1];
            boolean bl = compare = myNameComparator.compare(curr, next) == 0;
            if (compare || index > 0) {
                String name = curr.getName();
                this.nodesByName.remove(curr);
                curr.setName(String.valueOf(name) + " " + index);
                this.nodesByName.put(String.valueOf(name) + " " + index, curr);
                index = !compare ? 0 : ++index;
            }
            curr = next;
            ++i;
        }
    }

    public void updateLeaf(TreeNode t) {
        TreeNode[] tempLeaf = new TreeNode[this.leaf.length - 1];
        int i = 0;
        while (i < tempLeaf.length) {
            if (this.leaf[i] != t) {
                tempLeaf[i] = this.leaf[i];
            }
            ++i;
        }
        this.leaf = tempLeaf;
    }

    public void printLeaves() {
        int i = 0;
        while (i < this.leaf.length) {
            this.leaf[i].print();
            ++i;
        }
    }

    public int computeBin(int fontRange) {
        return (int)Math.floor(Math.exp(Math.log(this.nodeCount) / (double)fontRange)) + 1;
    }

    public void setNodeFontSize(int maxFontSize, int minFontSize) {
        if (this.getInteriorCount() > 0) {
            int fontRange = maxFontSize - minFontSize + 1;
            double maxValue = Math.log(this.nodeCount) / (double)fontRange;
            Iterator iter = this.nodes.iterator();
            while (iter.hasNext()) {
                TreeNode currNode = (TreeNode)iter.next();
                int fontSize = minFontSize;
                if (fontRange > 1 && !currNode.isLeaf()) {
                    fontSize = (int)(Math.log(currNode.getMax() - currNode.key) / maxValue) + minFontSize;
                }
                currNode.setFontSize(fontSize);
            }
        }
    }

    public TreeNode getLeaf(int index) {
        if (index >= 0 && index < this.leaf.length) {
            return this.leaf[index];
        }
        return null;
    }

    public int getMinObjectKey() {
        return 0;
    }

    public int getMaxObjectKey() {
        return 0;
    }

    public float getMinObjectValue() {
        return 0.0f;
    }

    public float getMaxObjectValue() {
        return 0.0f;
    }

    public int getObjectKeyAt(int i) {
        return 0;
    }

    public float getObjectValueAt(int i) {
        return 0.0f;
    }

    public ArrayList getObjects() {
        return null;
    }

    public int getNumber() {
        return this.number;
    }
}

