#include "Ranking.hpp"

//  version 1: numero de hijos en un vector; borradla si no la usais;
//  anadid la implementacion de las ops privadas que necesiteis, si la usais;

Ranking::Ranking(int m, int n)
{	
  M=m;
  num_organismos=n;
  vnhijos = vector<pair<int, int> > (M);
  for(int i=0;i<n;i++) {
    vnhijos[i].first=i+1;
    vnhijos[i].second=0;
  }
  vpadres=vector<pair<int, int> > (M);
  for(int i=0;i<M;i++)  vpadres[i].first=vpadres[i].second=0;
}
  
void Ranking::anadir_org(int i, int j, int k)
{
  vnhijos[k-1].first = k; 
  vnhijos[k-1].second = 0; 
  incrementar_y_recolocar(i); 
  incrementar_y_recolocar(j); 
  vpadres[k-1].first = i; 
  vpadres[k-1].second = j; 
  ++num_organismos;
}

bool Ranking::primero(const pair<int,int> &a, const pair<int,int> &b) {
  return a.second > b.second or (a.second == b.second and a.first < b.first); 
} 

void Ranking::incrementar_y_recolocar(int id) {
  int i = 0; 
  while (vnhijos[i].first != id) ++i; 
  ++(vnhijos[i].second); 
  pair<int,int> info = vnhijos[i]; 
  while (i > 0 and primero(info, vnhijos[i - 1])) {
     vnhijos[i] = vnhijos[i - 1];  
     --i;
  }
  vnhijos[i] = info;
}
 
void Ranking::anotar_muerte(int k)
{
  // rellenad el codigo de la operacion
}

// anadid aqui el codigo de las restantes operaciones privadas que necesiteis

int Ranking::tamano_max() const
{
  return M;
}

 int Ranking::tamano() const
{
  return num_organismos;
}
  
void Ranking::escribir_ranking() const
{
  for(int i=0; i<num_organismos; ++i)
    cout << vnhijos[i].first << " :" << vnhijos[i].second << endl;
  cout << endl;
}
// -------------------------- fin de la version 1 --------------------------


//  version 2: numero de hijos en una lista; borradla si no la usais;
//  anadid la implementacion de las ops privadas que necesiteis, si la usais;

Ranking::Ranking(int m, int n)
{	
  M=m;
  for(int i=0;i<n;++i) {
    pair<int, int> aux(i+1,0);
    lnhijos.insert(lnhijos.end(),aux);
  }
  vpadres=vector<pair<int, int> > (M);
  for(int i=0;i<M;++i)  vpadres[i].first=vpadres[i].second=0;
}
  
void Ranking::anadir_org(int i, int j, int k)
{
  pair<int, int> aux(k,0);
  lnhijos.insert(lnhijos.end(),aux);
  vpadres[k-1].first=i;
  vpadres[k-1].second=j;
  incrementar_y_recolocar(i);
  incrementar_y_recolocar(j);
}

bool Ranking::primero(const pair<int,int> &a, const pair<int,int> &b) {
  return a.second > b.second or (a.second == b.second and a.first < b.first); 
} 

void Ranking::incrementar_y_recolocar(int i)
{
  list<pair<int, int> >::iterator it = lnhijos.begin();   
  while (it->first != i) ++it;
  // i es un padre, se encuentra seguro
  ++(it->second);
  list<pair<int, int> >::iterator itorig = it;  
  bool b=false;
  while (it!=lnhijos.begin() and not b){
    list<pair<int, int> >::iterator itaux = it;
    --itaux;
    if (primero(*itorig, *itaux)) --it;
    else b=true;
  }
  if (it!=itorig){
    lnhijos.insert(it,*itorig);
    lnhijos.erase(itorig);
  }
}


void Ranking::anotar_muerte(int k)
{
  // rellenad el codigo de la operacion
}

// anadid aqui el codigo de las restantes operaciones privadas que necesiteis


int Ranking::tamano_max() const
{
  return M;
}

 int Ranking::tamano() const
{
  return lnhijos.size();
}
  
void Ranking::escribir_ranking() const
{
  list<pair<int, int> >:: const_iterator it = lnhijos.begin();  
  for(; it!=lnhijos.end(); ++it)
    cout << it->first << " :" << it->second << endl;
  cout << endl;
}

// -------------------------- fin de la version 2 --------------------------

