#ifndef _SISTEMA_
#define _SISTEMA_

#include "Ranking.hpp"
#include "Organismo.hpp"
#include <vector> 

class Sistema {

private:

  vector<Organismo> vect_organismos;
  // organismos almacenados segun su id; los actuales son [0..num_organismos-1]

  vector<vector<bool> > matriz_emparejamientos;
  // triangular; si i<j, la posicion [i-1][j-1] indica si el organismo i se ha
  // emparejado con el j; si i>=j la info no es relevante 
  
  int M; 
  // poblacion maxima permitida

  int num_organismos; 
  // poblacion historica (num_organismos+1 es el primer id aun no usado)

  int num_vivos; 
  // poblacion actual (solo vivos) 
 
 public:

  Sistema(int m); 
  /* Pre: m > 2 */
  /* Post: el resultado es un sistema de organismos vacio, preparado
     para contener hasta m organismos */

  void reproduccion(int i, int j, int& k, Ranking& r);
  /* Pre: p.i. = P, T = tamano_max(), tamano() < T; 1<=i<j<=T */
  /* Post: si i y j existen en P, estan vivos y no se habian reproducido,
     k es el id de su hijo y se han actualizado el p.i y r; en caso
     contrario, k=0 */

  void crecimiento(int o);
  /* Pre: p.i. = P, 1<=o<=tamano_max() */
  /* Post: si existe en P el organismo de id = o y esta vivo, se le ha
     aplicado un estiron; en caso contrario no se ha hecho nada */

  void muerte(int o, Ranking& r);
  /* Pre: p.i. = P, 1<=o<=tamano_max() */
  /* Post: si existe en P el organismo de id = o y esta vivo, ha pasado a estar
     muerto y se ha actualizado r; en caso contrario no se ha hecho nada */

  int tamano() const; 
  /* Pre: cierto */
  /* Post: el resultado es la poblacion historica del p.i. */

  int vivos() const; 
  /* Pre: cierto */
  /* Post: el resultado es la poblacion de organismos vivos del p.i. */

  int tamano_max() const;
  /* Pre: cierto */
  /* Post: el resultado es la poblacion maxima permitida del p.i. */

  void leer_sistema(int n); 
  /* Pre: 1<n<tamano_max(); el cin esta preparado para leer n organismos */
  /* Post: el p.i. pasa a contener n organismos con ids correlativos 1..n,
     asignados en orden de lectura */

  void escribir_un_organismo(int i) const; 
  /* Pre: 1<=i<=tamano_max() */
  /* Post: si existe el organismo con id = i en el p.i., se ha escrito su
     estructura; en caso contrario no se ha hecho nada */

  void escribir_organismos() const; 
  /* Pre: cierto */
  /* Post: se ha escrito la estructura de todos los organismos del p.i. */

};

#endif
