#ifndef RANKING_HPP
#define RANKING_HPP

// Este fichero contiene dos versiones de la clase Ranking: elegid una
// y borrad todos los elementos de la version que no vayais a usar

#include "utils.PRO2"
#include <vector>
#include <list>

class Ranking{

private:

  int M;
  // poblacion maxima

  // --- version 1: numero de hijos vivos en un vector; borradla si no la usais

  int num_organismos; 
  // poblacion actual (vivos o muertos)
 
  vector<pair<int, int> > vnhijos;
  // posiciones relevantes: 0<=i<num_organismos;
  //
  // vnhijos[i-1].first = id del i-esimo org que mas hijos vivos tiene;
  // vnhijos[i-1].second = num de hijos vivos del i-esimo org que mas hijos 
  // vivos tiene; ordenado decrecientemente segun second y, en caso de empate, 
  // crecientemente segun first

  // -------------------------- fin de la version 1 --------------------------


  // --- version 2: numero de hijos vivos en una lista; borradla si no la usais

  list<pair<int, int> > lnhijos;
  // lnhijos.size() = poblacion del ranking (vivos o muertos)
  // 
  // "iesimo elem. de lnhijos".first = id del i-esimo org que mas hijos vivos tiene;
  // iesimo.second = num de hijos vivos del i-esimo org que mas hijos vivos tiene;
  // ordenada decrecientemente segun second y, en caso de empate, 
  // crecientemente segun first

  // -------------------------- fin de la version 2 --------------------------


  // ----- vector auxiliar, obligatorio para las dos versiones, no borrar -----

  // El vector que aparece a continuacion sirve para consultar rapidamente los
  // padres de un organismo (si tiene); se debe usar tal cual

  vector<pair<int, int> > vpadres;
  // posiciones relevantes: 0<=i<poblacion del ranking (vivos o muertos)
  //
  // si el org con id = i esta en el ranking y procede de una reproduccion, 
  // vpadres[i-1].first y vpadres[i-1].second son los ids de sus padres
  // (vpadres[i-1].first<vpadres[i-1].second)
  // en caso contrario, vpadres[i-1].first=vpadres[i-1].second=0

public:
  
  // las operaciones son las mismas en las dos versiones

  Ranking(int m, int n);
  /* Pre: 2<=n<m */
  /* Post: el resultado es un ranking de n organismos sin hijos vivos (ids
     1..n), preparado para contener informacion de hasta m organismos */

  void anadir_org(int i, int j, int k);
  /* Pre: i,j estan en el p.i., 1<=<k=tamano_max() no esta en el p.i. */
  /* Post: el p.i. pasa a contener k, como hijo vivo de i y j */

  void anotar_muerte(int k);
  /* Pre: k esta en el p.i. */
  /* Post: el p.i. pasa a reflejar que k ha muerto: sigue en el p.i., pero si
     procede de una reproduccion, ya no cuenta como hijo vivo de nadie */

  int tamano_max() const;
  /* Pre: cierto */
  /* Post: el resultado es la poblacion maxima permitida del p.i. */

  int tamano() const;
  /* Pre: cierto */
  /* Post: el resultado es el numero de elementos del p.i. */

  void escribir_ranking() const;
  // Se escribe el num. de hijos vivos de los organismos vivos o muertos, en
  // orden de ranking;

private:

  void incrementar_y_recolocar(int id);
  /* Pre: id esta en el p.i. */
  /* Post: el contador de hijos vivos de id se incrementa en 1 (manteniendo el
     orden) en el p.i. */

  static bool primero(const pair<int,int> &a, const pair<int,int> &b);
  /* Pre: a y b son pairs validos como parte de un ranking */
  /* Post: el resultado indica si a ha de aparecer antes que b en un ranking */
  
  // aqui debeis escribir las cabeceras del resto de las operaciones
  // privadas que necesiteis

};

#endif
