#ifndef _ORGANISMO_
#define _ORGANISMO_

#include "Arbre.hpp"

class Organismo {

private:

  Arbre<int> celulas;
  int id_max;
 
public:

  Organismo(); 
  /* Pre: cierto */
  /* Post: el resultado es un organismo SIN CELULAS */ 

  void emparejamiento(const Organismo& o1, const Organismo& o2);
  /* Pre: o1 y o2 estan vivos */
  /* Post: el p.i. es el hijo resultante del emparejamiento de o1 y o2 */

  void estiron();
  /* Pre: el p.i. esta vivo  */
  /* Post: el p.i. ha sufrido un estiron */ 

  void muerte_org();
  /* Pre: el p.i. esta vivo */
  /* Post: el p.i. pasa a estar muerto */ 

  bool esta_vivo() const;
  /* Pre: cierto */
  /* Post: el resultado indica si el p.i. esta vivo */

  void leer_organismo();
  // eso

  void escribir_organismo () const;
  // eso

private: 
  static void llegir_arbre(Arbre<int>& a, int& m);
  static void escriure_arbre(Arbre<int>& a);

  // aqui debeis escribir las cabeceras + especificacion pre/post del
  // resto de las operaciones privadas que necesiteis

};
#endif
