#ifndef CLASIF
#define CLASIF

#include "Revista.hpp"
#include "Arbre.hpp"

class Clasificacion{

public:

  Clasificacion();
  /* Pre: cierto */ 
  /* Post: el resultado es una clasificacion vacia (0 areas tematicas) */

  void obtener_area(Revista& rev) const;
  /* Pre: las palabras clave de rev son un subconjunto de las areas
     del p.i. que no tienen ningun subarea */
  /* Post: rev pasa a tener el area correspondiente al criterio 2 del
     enunciado original aplicado sobre el p.i. */

  void leer_estructura_areas();
  /* Pre: el canal standard de entrada esta preparado para leer las
     areas de una clasificacion */
  /* Post: el p.i. contiene sus areas tomadas del canal standard de
     entrada */


private:

  Arbre<string> areas; // sus elementos no pueden valer "."

  static void llegir_arbre_string(Arbre<string>& a);
  /* Pre: a es vacio; el canal standard de entrada esta preparado para
     leer las areas de una clasificacion */
  /* Post: a contiene sus areas tomadas del canal standard de entrada */

  // completar con la cabecera y especificacion de las ops. privadas
  // que sean necesarias
 
};
#endif
