#ifndef BIBLIOTECA
#define BIBLIOTECA

#include "Revista.hpp"

class Biblioteca{

public:

  Biblioteca();
  /* Pre: cierto */ 
  /* Post: el resultado es una biblioteca vacia (0 revistas) */

  void alta_revista(const Revista& rev);
  /* Pre: rev es una revista con un area no vacia y un titulo que no
     corresponde a ninguna revista del p.i. */
  /* Post: se ha anadido rev al p.i. */ 

  void escribir_revistas(const string& area);
  /* Pre: cierto */
  /* Post: se han escrito en el canal standard de salida los titulos de las
     revistas del area "area" del p.i. */

private:
  
  list<Revista> list_rev; 
  // las revistas de list_rev estan ordenadas alfabeticamente por areas
  // y dentro de cada area, por titulo

  list<Revista>::iterator buscar_posicion_area(const string& area);
  /* Pre: cierto */
  /* Post: el resultado apunta a la primer revista del area "area" del p.i.,
     si contiene alguna; si no, apunta a la primera revista de la siguiente 
     area, si hay; si no, es el end del p.i. */
};
#endif
