#ifndef XARXA_HPP
#define XARXA_HPP

#include "Arbre.hpp"
#include <vector>
#include "Servidor.hpp"

class Xarxa {

private:
  Arbre<int> a;
  vector<Servidor> vs;
    
public:

  Xarxa (int N, int M);
  /* Pre:  N>0, M>0 */
  /* Post: el resultat es una xarxa buida amb capacitat per manegar N servidors
     i M pel.licules */

  void llegir_xarxa();
  /* Pre: al cin hi ha l'estructura de la xarxa de servidors */
  /* Post: al p.i. hi ha l'estructura de la xarxa de servidors */

  void llegir_servidors();
  /* Pre: al cin hi ha els amples de banda de tants servidors com la mida del
     p.i.  i els identificadors de les pelis que contenen */
  /* Post: cada servidor del p.i. te el seu ample de banda i la informacio
     sobre les seves pelis, pres del cin */

  void escriure_servidors(int t) const;
  /* Pre: 0 < t */
  /* Post: s'ha escrit pel cout la sequencia de servidors del p.i. ocupats per
     la peticio sol.licitada en l'instant t, ordenats creixentment per id */

  void escollir_servidors(int id_peli, int mida_peli, int t, int & d); 
  /* Pre: 1 <= id_peli <= M; 0 < mida_peli; 0 < t */
  /* Post: si el p.i. pot servir la pel.licula id_peli de mida mida_peli a
     l'instant t, d es la durada de la descarrega; altrament d = 0; si d > 0
     aleshores per a cada servidor escollit s'ha actualitzat el seu temps
     d'ocupacio */

private:

  static void llegir_arbre_int(Arbre<int>& a, int marca); 
  /* Pre: al cin hi ha l'estructura d'un arbre d'enters en preordre */
  /* Post: a es un arbre llegit del cin */

  // aqui poseu les operacions que faltin


};

#endif

