#include "Cjto_regiones.hpp" 
                             
int main() {

  int N = readint(); // num. especies total   
  int C = readint(); // num. especies carnivoras
  Cjto_especies animales(N,C);  // crea conjunto especies  
  animales.leer_especies();  // lee caractersticas de las especies
  animales.leer_orden_depredadores(); // lee orden global de los depredadores

  int R = readint();     // num. regiones
  Cjto_regiones cr(R,N); // crea conjunto regiones 
  cr.leer_estructura(); // lee el rbol de conexiones entre regiones
  cr.leer_regiones();   // lee num. individuos de cada especie en cada regin 
                            
  int op = readint(); // cdigo de operacin

  while (op != -6) {
    if (op == -1) {
      cr.lucha_supervivencia_global(animales); // lanza las luchas por regiones
    }
    else if (op == -2) {
      int r = readint();        // lee id. de regin origen
      int e = readint();        // lee id. de especie
      int h = readint();        // lee num. individuos que migran
      int g = readint();        // lee num. mnimo pra moverse
      cr.migrar_hacia_planicie(r,e,h,g); // lanza migracin hacia planicie
    }
    else if (op == -3) {
      int m = readint();        // lee num. individuos que nacen            
      int e = readint();        // lee id. de especie      
      int r = readint();        // lee id. de regin 
      cr.nacimientos(m,e,r);    // aade m indiv. de especie e en regin r 
    }
    else if (op == -4) {
      int e = readint();        // lee identificador de especie depredadora
      int p = readint();        // lee identificador de especie presa
      animales.actualizar_presa(e,p); // la presa de la especie e pasa a ser p 
    }
    else if (op == -5) {
      cr.escribir_poblaciones(); // escribe num. individuos de cada especie
                                 // en cada region
    }
    op = readint();
  } 

}
