#ifndef REGION_HPP
#define REGION_HPP

#include "Cjto_especies.hpp"

class Region {
public:
  Region (int N);       
  /* Pre: 1<=N */
  /* Post: el resultado es una regin vaca preparada para un mximo de N
     especies */

  void modificar_num_indiv_especie(int e, int m);
  /* Pre: 1<=e<= num. de especies del p.i. */
  /* Post: se han sumado m individuos a la especie e del p.i. */

  void lucha_supervivencia_region(const Cjto_especies &c); 
  /* Pre: cierto */
  /* Post: se han modificado las poblaciones de las especies de c del p.i.
     como resultado de las muertes en las luchas por la supervivencia */

  int consultar_num_indiv_especie(int e) const;
  /* Pre: 1<=e<= num. de especies del p.i. */
  /* Post: el resultado es el nmero de individuos de la especie e en el p.i. */ 

  void leer_region();    
  /* Pre: el canal standard de entrada est preparado para leer las poblaciones
     del p.i. */
  /* Post: el p.i. contiene sus poblaciones tomadas del canal standard de
     entrada */

  void escribir_poblaciones_region() const; 
  /* Pre: cierto */
  /* Post: se han escrito en el canal standard de salida el nmero de
     individuos de cada especie del p.i.*/
 

private:
  vector<int> poblacion;
};
#endif
