#ifndef CJTO_REGIONES_HPP
#define CJTO_REGIONES_HPP

#include "Region.hpp"
#include "Arbre.hpp"

class Cjto_regiones {
public:
  Cjto_regiones (int R, int N); 
  /* Pre: 1<=R, 1<=N */
  /* Post: el resultado es un conjunto vaco preparado para R regiones, cada
     una con N especies */

  void lucha_supervivencia_global(const Cjto_especies &c);
  /* Pre: cierto */
  /* Post: se han modificado las poblaciones de las especies de c en las
     regiones del p.i.  como resultado de las muertes en las luchas por la
     supervivencia */
  
  void migrar_hacia_planicie(int r, int e, int h, int g); 
  /* Pre: 1<=r<= num. de regiones del p.i.; 1<=e<= num. de especies del p.i.;
     0<=h<= num. de individuos de la especie e en la regin r; 0<g<h; r no es
     la planicie */
  /* Post: se han modificado las poblaciones de la especie e del p.i. en las
     regiones afectadas por una migracin de factor g de h individuos de esa
     especie desde la regin r hacia la planicie */

  void nacimientos(int m, int e, int r);
  /* Pre:  1<=r<= num. de regiones del p.i.; 1<=e<= num. de especies del p.i.;*/
  /* Post: se han sumado m individuos a la especie e en la regin r del p.i. */
 
  void leer_estructura();       
  /* Pre: el canal standard de entrada est preparado para leer las conexiones
     entre las regiones del p.i. (rbol de enteros en preorden) */
  /* Post: el p.i. contiene las conexiones entre sus regiones tomadas del canal
     standard de entrada */

  void leer_regiones();         
  /* Pre: el canal standard de entrada est preparado para leer las poblaciones
     de cada regin del p.i. */
  /* Post: el p.i. contiene las poblaciones de sus regiones tomadas del canal
     standard de entrada */

  void escribir_poblaciones() const;
  /* Pre: cierto */
  /* Post: se han escrito en el canal standard de salida el nmero de
     individuos de cada especie en cada regin del p.i.*/
  
private:
  Arbre <int> ecosistema; // rbol de conexiones entre regiones
  vector<Region> regs; // vector de regiones
  // la posicin i de regs contiene los datos de la region i+1 de ecosistema;
  // una vez creado un conjunto de regiones, los elementos de ecosistema
  // son los valores [1..regs.size()]

  // completar con las ops privadas
};

#endif
