#ifndef CJTO_ESPECIES_HPP
#define CJTO_ESPECIES_HPP

#include "utils.PRO2"
#include <vector>

class Cjto_especies {
public:
  Cjto_especies (int N, int C); 
  /* Pre: 1<=N,  1<=C<=N */
  /* Post: el resultado es un conjunto vaco preparado para N especies, de las
     cuales C son carnvoras */

  void actualizar_presa(int e, int p); 
  /* Pre: 1<=e,p<= num. de especies del p.i.; e es una especie depredadora */
  /* Post: la presa de la especie s del p.i. pasa a ser p */

  int num_depredadores() const;
  /* Pre: cierto */
  /* Post: el resultado es el nmero de depredadores del p.i.*/

  int depredador_iesimo(int i) const; 
  /* Pre: 1<=i<= num. de depredadores del p.i.; */
  /* Post: el resultado es el depredador de prioridad i del p.i. */

  int valor_alimenticio(int e) const; 
  /* Pre: 1<=e<= num. de especies del p.i.; */
  /* Post: el resultado es el valor alimenticio de la especie e del p.i. */

  int min_feed(int e) const; 
  /* Pre: 1<=e<= num. de especies del p.i. */
  /* Post: el resultado es el mnimo de unidades alimenticias que necesita la
     especie e del p.i. para sobrevivir */

  int presa(int e) const;
  /* Pre: 1<=e<= num. de especies del p.i.; e es una especie depredadora */
  /* Post: el resultado es la presa de la especie e del p.i. */
  
  void leer_especies();  
  /* Pre: el canal standard de entrada est preparado para leer las
     caractersticas de cada especie del p.i. */
  /* Post: el p.i. contiene las caractersticas de sus especies tomadas del
     canal standard de entrada */

  void leer_orden_depredadores(); 
  /* Pre: el canal standard de entrada est preparado para leer el orden de
     prioridad de los depredadores del p.i. */
  /* Post: el p.i. contiene el orden de prioridad de sus depredadores tomado
     del canal standard de entrada */

private:
  struct especie{
    int val_al; // Cuanto valor alimenticio aporta
    int val_min; // Cuanto valor alimenticio necesita
    int presa; // La especie que puede comer
  };
  vector<especie> esp;
  vector<int> prioridad;
};

#endif

