#ifndef CJT_MOTOS_HPP
#define CJT_MOTOS_HPP

#include "utils.PRO2"
#include <vector>


class Cjt_motos {
  private:  
    struct moto {
      int v,d,c;
    };
    int pot2n;
    vector<moto> cm;

  public:
    Cjt_motos(int pot2n);
    /* Pre: pot2n es una potencia de 2, pot2n >= 2 */
    /* Post: el resultat esta preparat per contenir les caracterstiques de
             pot2n motos */

    void llegir_motos();
    /* Pre: el canal estandar d'entrada conte pot2n (del p.i.) tuples 
            de tres enters <velocitat, consum, diposit> */
    /* Post: el p.i. conte les caracteristiques de les motos
             llegides del canal estandar d'entrada */

    int velocitat(int id) const;
    /* Pre: 1<= id <= pot2n del p.i. */
    /* Post: el resultat es la velocitat de la moto amb identificador id */ 
 
    int diposit(int id) const;
    /* Pre: 1<= id <= pot2n del p.i. */
    /* Post: el resultat es la capacitat del diposit de la moto amb 
             identificador id */ 

    int consum(int id) const;
    /* Pre: 1<= id <= pot2n del p.i. */
    /* Post: el resultat es el consum de la moto amb identificador id */
};

#endif
