#include "utils.PRO2"
#include "Historico.hpp"
#include "Cuenca.hpp"

int main(){

  int N=readint();  // número de nodos de la cuenca
  Cuenca c(N);      // lee la estructura de la cuenca e inicializa
                    // la información de sus nodos para representar una
                    // cuenca seca y sin depuradoras
  Historico h;      // inicializa histórico vacío
  int op=readint(); // lee código de operación
  while (op != -5) {
    if (op == -1) {
      int cmax=readint();    // caudal máximo de las depuradoras
      int gmax=readint();    // grado máximo de las depuradoras
      int fecha=readint();   // fecha evento
      c.leer_datos_evento(); // el número de tuplas del evento
                             // y dichas tuplas <k d c g> para
                             // reinicializar la info de los nodos
      int csal, gsal;
      c.propagar(cmax, gmax, csal, gsal); // calcula el caudal (csal) y el
                                          // grado (gsal) en la desembocadura
      cout << csal << " " << gsal << endl;   // escribe resultados
      h.anadir_evento(fecha,csal,gsal); // añade a histórico la fecha y 
                                        // los resultados del evento
    }
    else if (op == -3) {
      int fecha_sup=readint();   // lee la fecha límite superior
      int fecha_max, caudal, grado;
      h.evento_grado_maximo(fecha_sup, fecha_max, caudal, grado);
          // obtiene la fecha, el caudal y el grado del evento con
          // máximo grado anterior a la fecha fecha_sup (sin incluir ésta);
          // si no hay ningún evento antes de esa fecha,
          // fecha_max, caudal y grado serán cero     
      cout << "Max grado fecha " << fecha_sup << endl;
      cout << fecha_max << " " << caudal << " " << grado << endl;
    }
    op=readint();
  }

}
