#ifndef PILA_HPP
#define PILA_HPP

#include "utils.PRO2"
#include <stack>

template <class T>
class Pila {

public:

  //Constructoras

  /* crea una pila buida */
  Pila();

  /* crea una pila copia d'original */
  Pila(const Pila& original);

  //Destructora
  ~Pila();

  //Modificadores 

  /* buida la pila */
  void p_buida();

  /* afegeix l'element x a la pila */
  void empilar(const T &elemento);


  /* elimina l'ultim element afegit a la pila,
     si la pila es buida dona un error */
  void desempilar();

  //Consultores 

  /* retorna l'ultim element afegit a la pila,
     si la pila es buida dona un error */
  T cim() const;

  /* ens retorna si la pila es buida o no */
  bool es_buida() const;

private:
  
  stack<T> q;

};

#include "Pila.t"

#endif
