#ifndef _LLISTA_HPP
#define	_LLISTA_HPP

#include "utils.PRO2"
#include <list>

template <typename T>
class Llista {

private:
  list<T> l;
	
  //Definici dels iterators de Llista


  template <typename F> 
  class Const_Iterator_T;

  template <typename E>
  class Iterator_T: public std::iterator<std::bidirectional_iterator_tag, E> {
  private:
    typedef typename list<T>::iterator list_it;  
    list_it it;
    friend class Llista<T>;
    template <typename D2> friend class Const_Iterator_T;
          
  public:
   
    Iterator_T(){}
    Iterator_T& operator++() { ++it; return *this; }
    Iterator_T& operator--() { --it; return *this; }
    bool operator==(const Iterator_T& A) const {return it == A.it;}
    bool operator==(const Const_Iterator_T<E>& A) const {return it == A.it;}
    bool operator!=(const Iterator_T& A) const {return it != A.it;}
    bool operator!=(const Const_Iterator_T<E>& A) const {return it != A.it;}
    T& operator*() const {return *it;} 
    // No es pot assignar ni copiar un const_iterator a un iterator
  };

  //Definici dels const_iterator de Llista

  template <typename F>
  class Const_Iterator_T: public std::iterator<std::bidirectional_iterator_tag, F> {
  private:
    typedef typename list<T>::const_iterator const_list_it;
    const_list_it it;
    friend class Llista<T>;	
    template <typename D2> friend class Iterator_T;
 
 public:
    Const_Iterator_T(){}
    Const_Iterator_T(const Iterator_T<F>& A){it=A.it;}
    Const_Iterator_T& operator++() { ++it; return *this; }
    Const_Iterator_T& operator--() { --it; return *this; }
    bool operator==(const Const_Iterator_T& A) const {return it == A.it;}
    bool operator==(const Iterator_T<F>& A) const {return it == A.it;}
    bool operator!=(const Const_Iterator_T& A) const {return it != A.it;}
    bool operator!=(const Iterator_T<F>& A) const {return it != A.it;}
    Const_Iterator_T& operator=(const Iterator_T<F>& A) {it=A.it; return *this;}
    const T& operator*() const {return *it;}
  };	

  //Definici de les operacions de Llista

public:
  typedef Iterator_T<T> iterator;
  typedef Const_Iterator_T<T> const_iterator;

  //Constructoras

  Llista();
  /* Post: crea una llista sense cap element */

  //Destructora
  ~Llista();
   
  //Modificadores

  void l_nula();
  /* Post: buida la llista */

  void afegir(iterator it, const T &elem);
  /* Pre: it referencia algun element existent de la llista o 
     s igual al end() d'aquesta */
  /* Post: afegeix x a la llista davant de l'element referenciat per it */

  void eliminar(iterator & it);
  /* Pre: it = IT; L s la llista; 
     it referencia algun element existent de la llista  */
  /* Post: elimina de la llista l'element referenciat per IT; 
     it referencia l'element segent a IT en L */ 
		
  void concat(Llista<T> &l2);
  /* Pre: l2 = L2 */
  /* Post:  afegeix els elements d'L2 al final de la llista; buida l2 */


  //Consultores

  bool es_nula() const;
  /* Pre: cert */
  /* Post: indica si la llista t elements o no */
		
  int mida() const;
  /* Pre: cert */
  /* Post: retorna el nombre d'elements de la llista */

  //Consultores d'iterators

  iterator begin();
	
  const_iterator begin() const;

  iterator end();
	
  const_iterator end() const;

};
#include "Llista.t"

#endif
