#ifndef IMPLARBRE_HPP
#define IMPLARBRE_HPP

#include "utils.PRO2"


class Impl_Arbre {

public:

  Impl_Arbre();
  // Constructor

  Impl_Arbre(const void *raiz);
  // Constructor

  Impl_Arbre(const Impl_Arbre& original);
  // Constructor copia

  Impl_Arbre& operator=(const Impl_Arbre& original);

  ~Impl_Arbre();
  // Destructor


  void a_buit();
  /* Post: buida l'arbre */

  bool es_buit() const;
  /* Post: retorna si l'arbre s buit o no */

  void plantar(const void *arrel, Impl_Arbre& a);
  /* Pre: a = A */
  /* Post: El parmetre implcit t x com a arrel, el valor inicial del 
     parmetre implcit com a fill esquerre i A com a fill dret; buida a */ 

  void plantar(const void *arrel, Impl_Arbre& a1, Impl_Arbre& a2);
  /* Pre: a1 = A1; a2 = A2 */
  /* Post: El parmetre implcit t x com a arrel, A1 com a fill esquerre i 
     A2 com a fill dret; buida a1 i a2 */ 

  void fe();
  /* Pre: l'arbre no s buit. El valor d'entrada de l'arbre s A */
  /* Post: l'arbre pren per valor el fill esquerre d'A. 
     Provoca una excepcion si A es buit.*/

  void fe(const Impl_Arbre& a);
  /* Pre: a no s buit */
  /* Post: l'arbre pren per valor el fill esquerre d'a. 
     Provoca una excepcion si a es buit.*/

  void fd();
  /* Pre: l'arbre no s buit. El valor d'entrada de l'arbre s A */
  /* Post: l'arbre pren per valor el fill dret d'A. 
     Provoca una excepcion si A es buit.*/

  void fd(const Impl_Arbre& a);
  /* Pre: a no s buit */
  /* Post: l'arbre pren per valor el fill dret d'a. 
     Provoca una excepcion si a es buit.*/

  void fills(Impl_Arbre& iz, Impl_Arbre& der);
  /* Pre: l'arbre no s buit. El valor d'entrada de l'arbre s A. fe, fi no sn A */
  /* Post: fe pren per valor el fill esquerre d'A; fd pren per valor el 
     fill dret d'A; l'arbre queda buit; Provoca una excepcion si A es buit o si fe o fi sn A */

  void fills(Impl_Arbre& aux);
  /* Pre: l'arbre no s buit, aux s buit. El valor d'entrada de l'arbre s A */
  /* Post: l'arbre pren per valor el fill esquerre d'A. aux pren per valor el 
     fill dret d'A; Provoca una excepcion si A es buit o si aux no s buit */

  void * arrel() const;
  /* Pre: l'arbre no s buit */
  /* Post: retorna l'arrel de l'arbre (l'ultim element plantat);
     Provoca una excepcion si a es buit.*/


	
  private:

        struct node_arbre;
        node_arbre *node;

};

#endif


