#ifndef CUENCA_HPP
#define CUENCA_HPP

#include "utils.PRO2"

class Cuenca {
  private:  // Completar

  public:
    Cuenca(int n);
    /* Pre: n>0, el canal estándar de entrada contiene un listado en preorden de
       un árbol de n enteros (con valores diferentes entre 1 y n) y con marca
       cero */
    /* Post: el resultado es una cuenca seca y sin depuradoras y con la
       estructura de n nodos leída del canal estándar de entrada */

    void leer_datos_evento();
    /* Pre: el canal estándar de entrada contiene un entero m (0 < m <= nodos
       del p.i.) y m tuplas de cuatro enteros <k,d,c,g> donde k es un
       identificador de nodo, d es 0 o 1 y sólo será 1 para nodos no origen que
       han de tener depuradora, c>=0 es un valor de caudal que sólo podrá ser
       distinto de cero para nodos origen, g>=0 es un valor de grado de
       contaminación que sólo podrá ser distinto de cero para nodos origen;
       todos los identificadores de nodos origen aparecerán en las tuplas con
       sus correspondientes caudal y grado */
    /* Post: reinicializa la información de los nodos de la cuenca p.i. a partir
       de las m tuplas <k,d,c,g> leídas del canal estándar de entrada; los nodos
       no origen cuyo identificador no aparezca en las tuplas no tienen
       depuradora */

    void propagar(int cmax, int gmax, int &csal, int &gsal);
    /* Pre: cmax>0 y gmax>0 indican respectivamente los valores de caudal máximo
       y grado máximo de todas las depuradoras presentes en la cuenca p.i.; el
       p.i. contiene información actualizada de caudal y grado de todos sus
       nodos origen y en qué nodos no origen hay depuradoras */
    /* Post: csal y gsal son respectivamente el caudal y el grado de
       contaminación obtenidos en la desembocadura de la cuenca p.i. después de
       propagar caudales y grados de contaminación desde los nodos origen y
       aplicar las posibles depuradoras que existan en los nodos no origen */ 
};

#endif
