#ifndef CUA_HPP
#define CUA_HPP

#include "utils.PRO2"
#include <queue>

template <class T>
class Cua {

public:

  //Constructor

  /* crea una cua buida */
  Cua();

  /* crea una cua copia d'original */
  Cua(const Cua& original);

  //Destructor
  ~Cua();

  //Modificadores 

  /* buida la cua */
  void c_buida();

  /* afegeix l'element x al final de la cua */
  void demanar_torn(const T &elemento);

  /* elimina el primer element de la cua,
     si la cua s buida dona un error */
  void avancar();

  //Cosultores 

  /* torna el primer valor afegit a la cua,
     si la cua s buida dona un error */
  T primer() const;

  /* ens retorna si la cua s buida o no */
  bool es_buida() const;

private:
  
  queue<T> q;

};

#include "Cua.t"

#endif
