#ifndef ARBRE_HPP
#define ARBRE_HPP

#include "utils.PRO2"
#include "Impl_Arbre.hpp"

template <class T>
class Arbre {
	
public:

  // Constructor
  Arbre();
  /* Post: crea un arbre buit */  

  Arbre(const T& arrel);
  /* Post: crea un arbre amb arrel com a nic element  */

  Arbre(const Arbre& original);
  /* Post: crea un arbre copia d'original */

  Arbre& operator=(const Arbre& original);
  /* Post: Assigna un arbre copia de original*/

  // Destructora
  ~Arbre();

  //Modificadores

  void a_buit();
  /* Post: buida l'arbre */
  
  void plantar(const T& arrel, Arbre& a);
  /* Pre: a = A */
  /* Post: El parmetre implcit t x com a arrel, el valor inicial del 
     parmetre implcit com a fill esquerre i A com a fill dret; buida a */ 

  void plantar(const T& arrel, Arbre& a1, Arbre& a2);
  /* Pre: a1 = A1; a2 = A2 */
  /* Post: El parmetre implcit t x com a arrel, A1 com a fill esquerre i 
     A2 com a fill dret; buida a1 i a2 */ 

  void fills(Arbre& fe, Arbre& fd);
  /* Pre: l'arbre no s buit. El valor d'entrada de l'arbre s A. fe, fd no sn A */
  /* Post: fe pren per valor el fill esquerre d'A; fd pren per valor el 
     fill dret d'A; l'arbre queda buit; Provoca una excepci si A es buit o si fe o fi sn A */

  void fills(Arbre& aux);
  /* Pre: l'arbre no s buit, aux s buit. El valor d'entrada de l'arbre s A */
  /* Post: l'arbre pren per valor el fill esquerre d'A. aux pren per valor el 
     fill dret d'A; Provoca una excepci si A es buit o si aux no s buit */

  void fe();
  /* Pre: l'arbre no s buit. El valor d'entrada de l'arbre s A */
  /* Post: l'arbre pren per valor el fill esquerre d'A. 
     Provoca una excepcion si A es buit.*/

  void fe(const Arbre& a);	
  /* Pre: a no s buit */
  /* Post: l'arbre pren per valor el fill esquerre d'a. 
     Provoca una excepcion si a es buit.*/

  void fd();
  /* Pre: l'arbre no s buit. El valor d'entrada de l'arbre s A */
  /* Post: l'arbre pren per valor el fill dret d'A. 
     Provoca una excepcion si A es buit.*/

  void fd(const Arbre& a);	
  /* Pre: a no s buit */
  /* Post: l'arbre pren per valor el fill dret d'a. 
     Provoca una excepcion si a es buit.*/

  //Consultores

  T arrel() const;
  /* Pre: l'arbre no s buit */
  /* Post: retorna l'arrel de l'arbre (l'ultim element plantat);
     Provoca una excepcion si a es buit.*/

  bool es_buit() const;
  /* Post: retorna si l'arbre s buit o no */


  private:

  Impl_Arbre p;

};

#include "Arbre.t"

#endif
